package Application::Model::PartnerDB::Users;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME $MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        users => {
            fields => [
                {name => 'id',        type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'uid',       type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'login',     type => 'VARCHAR', length   => 40,   not_null => TRUE},
                {name => 'client_id', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default       => 0},
                {name => 'name',      type => 'VARCHAR', length   => 255,  not_null => TRUE, default       => ''},
                {name => 'lastname',  type => 'VARCHAR', length   => 255,  not_null => TRUE, default       => ''},
                {name => 'midname',   type => 'VARCHAR', length   => 255,  not_null => TRUE, default       => ''},
                {name => 'email',     type => 'VARCHAR', length   => 255,  not_null => TRUE},
                {name => 'phone',     type => 'VARCHAR', length   => 255,  not_null => TRUE, default       => ''},
                {name => 'accountant_email', type => 'VARCHAR', length   => 255},
                {name => 'newsletter',       type => 'BOOLEAN', not_null => TRUE, default => 1},
                {name => 'multistate',       type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'country_id',       type => 'INT',     unsigned => TRUE,},
                {name => 'business_unit',             type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'no_stat_monitoring_emails', type => 'BOOLEAN', not_null => TRUE, default => 1},
                {name => 'is_tutby',                  type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
                {name => 'block_light_form_enabled', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'opts',                     type => 'JSON',    not_null => TRUE},
                {
                    name      => 'has_tutby_agreement',
                    type      => 'BOOLEAN',
                    generated => 'opts->"$.has_tutby_agreement"',
                },
                {
                    name      => 'has_common_offer',
                    type      => 'BOOLEAN',
                    generated => 'opts->"$.has_common_offer"',
                },
                {
                    name      => 'has_approved',
                    type      => 'BOOLEAN',
                    generated => 'opts->"$.has_approved"',
                },
                {
                    name      => 'has_rsya',
                    type      => 'BOOLEAN',
                    generated => 'opts->"$.has_rsya"',
                },
                {
                    name      => 'has_mobile_mediation',
                    type      => 'BOOLEAN',
                    generated => 'opts->"$.has_mobile_mediation"',
                },

                # дата последней выплаты
                {name => 'last_payout', type => 'DATETIME', not_null => FALSE},

                # Флаг. Используется в крон скрипте. Если 1 - нужно отправить письмо в процессинг.
                {name => 'need_to_email_processing', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'is_mobile_mediation',      type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'is_video_blogger',         type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'domain_login',             type => 'VARCHAR', length   => 255},
                {name => 'is_adfox_partner',         type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'is_games',                 type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'is_dm_lite',               type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'is_efir_blogger',          type => 'BOOLEAN', not_null => TRUE, default => 0},

                #GDPR
                {name => 'is_deleted',    type => 'BOOLEAN',  not_null => TRUE, default => 0},
                {name => 'deletion_date', type => 'DATETIME', not_null => FALSE},
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => [qw(login)], unique => 1}, {fields => [qw(client_id)]}, {fields => [qw(uid)]}],
        },

        users_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'users',
            elem_table_pk => ['id'],
            with_opts     => {type => 'MEDIUMTEXT'}
        },

        user_adfox => {
            fields => [
                {name => 'user_id'},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE},
                {name => 'adfox_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'adfox_login', type => 'VARCHAR', length => 255, not_null => TRUE},
            ],
            primary_key => [qw(user_id adfox_id)],
            indexes     => [{fields => [qw(adfox_id)], unique => 1}, {fields => [qw(user_id)], unique => 1}],
            foreign_keys => [[[qw(user_id)] => users => [qw(id)]]]
        },

        user_global_excluded_domains => {
            fields => [
                {name => 'id',     type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'user_id'},
                {name => 'domain', type => 'VARCHAR', length   => 255,  not_null => 1,    collation     => 'utf8_bin'}
            ],
            primary_key  => [qw(id)],
            foreign_keys => [[['user_id'] => users => ['id']]],
            indexes      => [{fields => [qw(user_id domain)], unique => 1}],
        },

        user_global_excluded_phones => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'user_id'},
                {name => 'phone', type => 'VARCHAR', length => 64, not_null => 1}
            ],
            primary_key  => [qw(id)],
            foreign_keys => [[['user_id'] => users => ['id']]],
            indexes      => [{fields => [qw(user_id phone)], unique => 1}],
        },

        user_features => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'user_id'},
                {name => 'feature', type => 'VARCHAR', length => 64, not_null => 1}
            ],
            primary_key  => [qw(id)],
            foreign_keys => [[['user_id'] => users => ['id']]],
            indexes      => [{fields => [qw(user_id feature)], unique => 1}],
        },

        form_data => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'dt',         type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'user_id',    type => 'BIGINT',   unsigned => TRUE, not_null => TRUE},
                {name => 'client_id',  type => 'BIGINT',   unsigned => TRUE, not_null => TRUE},
                {name => 'person_id',  type => 'BIGINT',   unsigned => TRUE, not_null => FALSE},
                {name => 'country_id', type => 'INT',      unsigned => TRUE, not_null => TRUE},
                {name => 'branch_id',  type => 'VARCHAR',  length   => 255,  not_null => TRUE},
                {name => 'data',       type => 'MEDIUMTEXT'},
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => [qw(user_id)]}, {fields => [{name => 'branch_id', length => 15}]}],
        },

        form_version => {
            fields => [
                {name => 'dt',      type => 'DATETIME', not_null => TRUE},
                {name => 'user_id', type => 'BIGINT',   unsigned => TRUE, not_null => TRUE},
                {name => 'version', type => 'INT',      unsigned => TRUE, not_null => TRUE},
            ],
            primary_key => [qw(user_id)],
        },

        common_offer_allowed_users => {
            fields => [
                {name => 'user_id'},
                {name => 'deadline', type => 'DATE', not_null => TRUE},
                {name => 'accept_date', type => 'DATETIME', not_null => FALSE},
                {name => 'inn_ignore', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'opts', type => 'JSON', not_null => TRUE},
            ],
            primary_key  => [qw(user_id)],
            foreign_keys => [[['user_id'] => users => ['id']]],
        },
        common_offer_black_list => {
            fields      => [{name => 'user_id'}, {name => 'opts', type => 'JSON', not_null => TRUE},],
            primary_key => [qw(user_id)],
            foreign_keys => [[['user_id'] => users => ['id']]],
        },
    },
);
