package Application::Model::PartnerDB::VideoAN;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        video_an_site => {
            fields => [
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'owner_id'},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'caption',     type => 'VARCHAR',  length   => 255,  not_null => TRUE},
                {name => 'domain',      type => 'VARCHAR',  length   => 255,  not_null => TRUE},
                {name => 'multistate',  type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'platform',    type => 'TINYINT',  unsigned => TRUE, not_null => TRUE},
                #{name => 'show_count', type => 'TINYINT',   unsigned => TRUE, default  => 25},
                #{name => 'interval',   type => 'MEDIUMINT', unsigned => TRUE, default  => 604800},
                {name => 'comment',             type => 'VARCHAR', length   => 255,},
                {name => 'skin',                type => 'VARCHAR', length   => 255, not_null => TRUE, default => ''},
                {name => 'title',               type => 'VARCHAR', length   => 255, not_null => TRUE, default => ''},
                {name => 'skip_delay',          type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 5},
                {name => 'skip_time_left_show', type => 'BOOLEAN', not_null => TRUE,},
                {name => 'time_left_show', type => 'BOOLEAN',  not_null => TRUE, default  => 1},
                {name => 'skin_timeout',   type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 5000},
                {
                    name     => 'vast_version',
                    type     => 'TINYINT',
                    length   => 1,
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 3
                },
                {name => 'vast_timeout',  type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 5000},
                {name => 'video_timeout', type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 5000},
                {
                    name     => 'buffer_full_timeout',
                    type     => 'SMALLINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 5000
                },
                {name => 'buffer_empty_limit', type => 'TINYINT',  unsigned => TRUE, not_null => TRUE, default => 5},
                {name => 'vpaid_enabled',      type => 'BOOLEAN',  not_null => TRUE, default  => 1},
                {name => 'vpaid_timeout',      type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 5000},
                {name => 'wrapper_timeout',    type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 5000},
                {name => 'wrapper_max_count',  type => 'TINYINT',  unsigned => TRUE, not_null => TRUE, default => 3},
                {name => 'blocks_limit',       type => 'BIGINT',   not_null => TRUE, default  => 200},
                {name => 'blocks_count',       type => 'BIGINT',   not_null => TRUE, default  => 0},
                {name => 'partner_type',       type => 'VARCHAR',  length   => 10,},
                {name => 'pixels',      type => 'MEDIUMTEXT',},
                {name => 'update_time', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'send_time',   type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'user_synchronization', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'tag_id',                  type => 'INT',     unsigned => TRUE,},
                {name => 'unmoderated_rtb_auction', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {
                    name    => 'tier',
                    type    => 'TINYINT',
                    default => 3,
                },
                {name => 'metrica_counters', type => 'VARCHAR', length   => '1024', not_null => TRUE, default => ''},
                {name => 'opts',             type => 'JSON',    not_null => TRUE},
                {name => 'creator_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'patch',      type => 'JSON'},
            ],
            primary_key  => ['id'],
            indexes      => [{fields => ['multistate']}, {fields => ['domain']}],
            foreign_keys => [[['owner_id'] => users => ['id']], [['creator_id'] => users => ['id']],],
        },

        video_an_site_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'video_an_site',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        video_an_site_block_seq => {
            fields =>
              [{name => 'site_id'}, {name => 'next_block_id', type => 'INT', unsigned => TRUE, not_null => TRUE}],
            primary_key  => ['site_id'],
            foreign_keys => [[['site_id'] => video_an_site => ['id']]]
        },

        video_an_site_category_seq => {
            fields =>
              [{name => 'site_id'}, {name => 'next_category_id', type => 'INT', unsigned => TRUE, not_null => TRUE}],
            primary_key  => ['site_id'],
            foreign_keys => [[['site_id'] => video_an_site => ['id']]]
        },

        video_an_site_scenario_seq => {
            fields =>
              [{name => 'site_id'}, {name => 'next_scenario_id', type => 'INT', unsigned => TRUE, not_null => TRUE}],
            primary_key  => ['site_id'],
            foreign_keys => [[['site_id'] => video_an_site => ['id']]]
        },

        video_an_site_mirrors => {
            fields => [{name => 'site_id'}, {name => 'domain', type => 'VARCHAR', length => 64, not_null => 1}],
            primary_key  => [qw(site_id domain)],
            foreign_keys => [[['site_id'] => video_an_site => ['id']]]
        },

        video_an_site_blockings => {
            fields => [
                {name => 'site_id'},
                {name => 'content_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'type', type => 'VARCHAR', length => 11, not_null => TRUE},
                {name => 'name', type => 'VARCHAR', length => 64, not_null => TRUE}
            ],
            primary_key  => [qw(site_id content_id type)],
            foreign_keys => [[['site_id'] => video_an_site => ['id']]]
        },

        video_an_site_categories => {
            fields => [
                {name => 'id',        type => 'BIGINT', unsigned => TRUE, not_null => TRUE,},
                {name => 'page_id',},
                {name => 'parent_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE,},
                {name => 'name',    type => 'VARCHAR', length => 255, not_null => TRUE, i18n    => TRUE,},
                {name => 'comment', type => 'VARCHAR', length => 255, not_null => TRUE, default => '', i18n => TRUE,},
                {name => 'link',     type => 'VARCHAR', length   => 255,  not_null => TRUE,},
                {name => 'archived', type => 'BOOLEAN', not_null => TRUE, default  => 0},
            ],
            primary_key => ['id', 'page_id'],
            foreign_keys => [[['page_id'] => video_an_site => ['id']]],
        },

        video_an_site_instream => {
            fields => [
                {name => 'page_id'},
                {name => 'vmap_id'},
                {name => 'id', type => 'INT', unsigned => 1, not_null => 1},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => TRUE, default => ''},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'mincpm', type => 'SMALLINT', unsigned => TRUE},
                {name => 'geo',    type => 'MEDIUMTEXT'},
                {name => 'blind',         type => 'TINYINT',  unsigned => TRUE,  not_null => TRUE, default => 0},
                {name => 'category_id',   type => 'BIGINT',   unsigned => TRUE,  not_null => TRUE},
                {name => 'category_path', type => 'VARCHAR',  length   => '255', not_null => TRUE, default => ''},
                {name => 'type',          type => 'TINYINT',  unsigned => TRUE,  not_null => TRUE},
                {name => 'comment',       type => 'VARCHAR',  length   => '255', not_null => TRUE, default => ''},
                {name => 'start_time',    type => 'SMALLINT', unsigned => TRUE,},
                {name => 'allow_multiple_dsp_ads', type => 'BOOLEAN', not_null => TRUE, default => 1},
                {name => 'max_duration', type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 180},
                {name => 'count_positions',  type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 6},
                {name => 'alternative_code', type => 'MEDIUMTEXT',},
                {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'bk_data',           type => 'MEDIUMTEXT',},
                {name => 'adfox_block',       type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'strategy',      type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'video_active',  type => 'BOOLEAN',},
                {name => 'video_blocked', type => 'BOOLEAN',},
                {name => 'video_cpm',                 type => 'SMALLINT', unsigned => TRUE,},
                {name => 'video_performance_active',  type => 'BOOLEAN',},
                {name => 'video_performance_blocked', type => 'BOOLEAN',},
                {name => 'video_performance_cpm',     type => 'SMALLINT', unsigned => TRUE,},
                {name => 'video_motion',      type => 'BOOLEAN',  not_null => TRUE, default => 1},
                {name => 'repeat',            type => 'TINYINT',  unsigned => TRUE,},
                {name => 'broadcast_replace', type => 'TINYINT',  unsigned => TRUE,},
                {name => 'pip',               type => 'TINYINT',  unsigned => TRUE,},
                {name => 'repeat_after',      type => 'SMALLINT', unsigned => TRUE,},
                {name => 'max_repeat_count',  type => 'SMALLINT', unsigned => TRUE,},
                {name => 'server_side',       type => 'TINYINT',  unsigned => TRUE,},
                {name => 'try_client',        type => 'TINYINT',  unsigned => TRUE,},
                {name => 'opts',              type => 'JSON',     not_null => TRUE,},
            ],
            primary_key  => [qw(page_id id)],
            foreign_keys => [
                [['page_id'] => video_an_site => ['id']],
                [['page_id', 'vmap_id'] => video_scenaries => ['page_id', 'id']],
            ],
            indexes => [{fields => ['multistate']}, {fields => [qw(id)]}],
        },

        video_an_site_instream_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'video_an_site_instream',
            elem_table_pk => ['page_id', 'id'],
            with_opts     => TRUE
        },

        video_scenaries => {
            fields => [
                {name => 'page_id'},
                {name => 'id', type => 'INT', unsigned => 1, not_null => 1},
                {name => 'caption', type => 'VARCHAR', length => 255, not_null => TRUE,},
                {name => 'opts',        type => 'JSON',     not_null => TRUE,},
                {name => 'multistate',  type => 'BIGINT',   not_null => TRUE, default => 0},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
            ],
            primary_key  => [qw(page_id id)],
            foreign_keys => [[['page_id'] => video_an_site => ['id']],],
            indexes      => [{fields => ['multistate']}, {fields => [qw(id)]}],
        },

        video_scenaries_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'video_scenaries',
            elem_table_pk => ['page_id', 'id'],
            with_opts     => TRUE
        },

        statistics_video_an_site_instream => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'page_id',     type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id',      type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'tag_id',               type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'instream_block_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'instream_block_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'instream_block_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'instream_block_hits_unsold', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'instream_block_direct_shows',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_block_direct_clicks',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'instream_all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'instream_all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',           type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_w_nds',       type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'instream_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'instream_block_bad_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'instream_block_bad_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_block_bad_win_hits',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_block_bad_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_block_bad_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_bad_win_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_bad_win_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'bad_win_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'bad_win_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'instream_bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_block_win_hits',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_block_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'instream_block_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
            ],
            primary_key  => [qw(dt page_id block_id dsp_id currency_id tag_id)],
            indexes      => [{fields => [qw(page_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['page_id', 'block_id'] => video_an_site_instream => ['page_id', 'id']],
            ],
        },

        video_an_site_inpage => {
            fields => [
                {name => 'page_id'},
                {name => 'id', type => 'INT', unsigned => 1, not_null => 1},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => TRUE, default => ''},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'mincpm', type => 'SMALLINT', unsigned => TRUE},
                {name => 'geo',    type => 'MEDIUMTEXT'},
                {name => 'blind',         type => 'TINYINT', unsigned => TRUE,  not_null => TRUE, default => 0},
                {name => 'category_id',   type => 'BIGINT',  unsigned => TRUE,  not_null => TRUE},
                {name => 'category_path', type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'type',          type => 'TINYINT', unsigned => TRUE,  not_null => TRUE},
                {name => 'comment',       type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'max_duration',  type => 'TINYINT', unsigned => TRUE,  not_null => TRUE, default => 180},
                {name => 'alternative_code',  type => 'MEDIUMTEXT',},
                {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'bk_data',           type => 'MEDIUMTEXT',},
                {name => 'adfox_block',       type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'strategy',          type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'video_active',      type => 'BOOLEAN',},
                {name => 'video_blocked',     type => 'BOOLEAN',},
                {name => 'video_cpm',                 type => 'SMALLINT', unsigned => TRUE,},
                {name => 'video_performance_active',  type => 'BOOLEAN',},
                {name => 'video_performance_blocked', type => 'BOOLEAN',},
                {name => 'video_performance_cpm',     type => 'SMALLINT', unsigned => TRUE,},
                {name => 'video_motion',    type => 'BOOLEAN', not_null => TRUE, default => 1},
                {name => 'hide_at_the_end', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'auto_repeat',     type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'stick_outstream', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'opts',            type => 'JSON',    not_null => TRUE,},
            ],
            primary_key  => [qw(page_id id)],
            foreign_keys => [[['page_id'] => video_an_site => ['id']],],
            indexes      => [{fields => ['multistate']}, {fields => [qw(id)]}],
        },

        video_an_site_inpage_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'video_an_site_inpage',
            elem_table_pk => ['page_id', 'id'],
            with_opts     => TRUE
        },

        statistics_video_an_site_inpage => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'page_id',     type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id',      type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'tag_id',             type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'inpage_block_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'inpage_block_shows_own_adv', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'inpage_block_hits',          type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'inpage_block_hits_own_adv',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'inpage_block_hits_unsold',   type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'inpage_block_direct_shows',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'inpage_block_direct_clicks', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'inpage_all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'inpage_all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',        type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_w_nds',     type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds',    type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'inpage_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'inpage_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'inpage_block_bad_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'inpage_block_bad_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'inpage_block_bad_win_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'inpage_block_bad_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'inpage_block_bad_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'inpage_bad_win_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'inpage_bad_win_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'bad_win_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'bad_win_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'inpage_bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'inpage_bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'inpage_block_win_hits',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'inpage_block_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'inpage_block_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
            ],
            primary_key  => [qw(dt page_id block_id dsp_id currency_id tag_id)],
            indexes      => [{fields => [qw(page_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['page_id', 'block_id'] => video_an_site_inpage => ['page_id', 'id']],
            ],
        },

        video_an_site_fullscreen => {
            fields => [
                {name => 'page_id'},
                {name => 'id', type => 'INT', unsigned => 1, not_null => 1},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => TRUE, default => ''},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'mincpm', type => 'SMALLINT', unsigned => TRUE},
                {name => 'geo',    type => 'MEDIUMTEXT'},
                {name => 'blind',         type => 'TINYINT', unsigned => TRUE,  not_null => TRUE, default => 0},
                {name => 'category_id',   type => 'BIGINT',  unsigned => TRUE,  not_null => TRUE},
                {name => 'category_path', type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'type',          type => 'TINYINT', unsigned => TRUE,  not_null => TRUE},
                {name => 'comment',       type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'max_duration',  type => 'TINYINT', unsigned => TRUE,  not_null => TRUE, default => 180},
                {name => 'alternative_code',  type => 'MEDIUMTEXT',},
                {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'bk_data',           type => 'MEDIUMTEXT',},
                {name => 'adfox_block',       type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'strategy',          type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'video_active',      type => 'BOOLEAN',},
                {name => 'video_blocked',     type => 'BOOLEAN',},
                {name => 'video_cpm',                 type => 'SMALLINT', unsigned => TRUE,},
                {name => 'video_performance_active',  type => 'BOOLEAN',},
                {name => 'video_performance_blocked', type => 'BOOLEAN',},
                {name => 'video_performance_cpm',     type => 'SMALLINT', unsigned => TRUE,},
                {name => 'video_motion', type => 'BOOLEAN', not_null => TRUE, default => 1},
                {name => 'opts',         type => 'JSON',    not_null => TRUE},
            ],
            primary_key  => [qw(page_id id)],
            foreign_keys => [[['page_id'] => video_an_site => ['id']],],
            indexes      => [{fields => ['multistate']}, {fields => [qw(id)]}],
        },

        video_an_site_fullscreen_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'video_an_site_fullscreen',
            elem_table_pk => ['page_id', 'id'],
            with_opts     => TRUE
        },

        statistics_video_an_site_fullscreen => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'page_id',     type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id',      type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'tag_id',                 type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'fullscreen_block_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'fullscreen_block_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'fullscreen_block_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'fullscreen_block_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_block_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_block_direct_shows',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_block_direct_clicks',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'fullscreen_all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'fullscreen_all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',             type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',            type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_w_nds',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds',        type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'fullscreen_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'fullscreen_block_bad_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'fullscreen_block_bad_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_block_bad_win_hits',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_block_bad_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_block_bad_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_bad_win_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_bad_win_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'bad_win_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'bad_win_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'fullscreen_bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_block_win_hits',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_block_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'fullscreen_block_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
            ],
            primary_key => [qw(dt page_id block_id dsp_id currency_id tag_id)],
            indexes     => [{fields => [qw(page_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [[['currency_id'] => currencies => ['id']],],
        },

        statistics_video_an_site_page => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'page_id',},
                {name => 'category_id', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE,},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'instream_block_preroll_shows',      type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_preroll_hits',       type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_preroll_all_hits',   type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_postroll_shows',     type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_postroll_hits',      type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_postroll_all_hits',  type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_midroll_shows',      type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_midroll_hits',       type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_midroll_all_hits',   type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_pauseroll_shows',    type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_pauseroll_hits',     type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_pauseroll_all_hits', type => 'INT', unsigned => TRUE, not_null => TRUE},

                {name => 'instream_block_inroll_shows',    type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_inroll_hits',     type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_inroll_all_hits', type => 'INT', unsigned => TRUE, not_null => TRUE},

                {name => 'instream_block_s2sroll_shows',    type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_s2sroll_hits',     type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_s2sroll_all_hits', type => 'INT', unsigned => TRUE, not_null => TRUE},

                {name => 'instream_block_overlay_shows',    type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_overlay_hits',     type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_overlay_all_hits', type => 'INT', unsigned => TRUE, not_null => TRUE},

                {name => 'instream_block_view',        type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'instream_block_open_player', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_fraud_shows',             type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_fraud_clicks',            type => 'INT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt page_id category_id currency_id)],
            foreign_keys => [[['page_id'] => video_an_site => ['id']],],
        },

        (
            map {
                +"statistics_${_}_publisher" => {
                    fields => [
                        {name => 'dt',       type => 'DATE', not_null => TRUE},
                        {name => 'page_id',  type => 'INT',  unsigned => TRUE, not_null => TRUE},
                        {name => 'block_id', type => 'INT',  unsigned => TRUE, not_null => TRUE},
                        {name => 'dsp_id',   type => 'INT',  unsigned => TRUE, not_null => TRUE},
                        {
                            name     => 'currency_id',
                            type     => 'TINYINT',
                            unsigned => TRUE,
                            not_null => TRUE,
                            default  => 2
                        },

                        {name => 'publisher_id', type => 'VARCHAR', length => 255, not_null => TRUE, default => ''},
                        {name => 'content_id',   type => 'VARCHAR', length => 255, not_null => TRUE, default => ''},
                        {
                            name     => 'publisher_name',
                            type     => 'VARCHAR',
                            length   => 255,
                            not_null => TRUE,
                            default  => ''
                        },
                        {name => 'content_name', type => 'VARCHAR', length   => 255,  not_null => TRUE, default => ''},
                        {name => 'clid',         type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},

                        {name => 'video_bk_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                        {
                            name     => 'video_bk_shows_own_adv',
                            type     => 'INT',
                            unsigned => TRUE,
                            not_null => TRUE,
                            default  => 0
                        },

                        {name => 'video_bk_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                        {
                            name     => 'video_bk_hits_own_adv',
                            type     => 'INT',
                            unsigned => TRUE,
                            not_null => TRUE,
                            default  => 0
                        },
                        {
                            name     => 'video_bk_hits_unsold',
                            type     => 'INT',
                            unsigned => TRUE,
                            not_null => TRUE,
                            default  => 0
                        },
                        {
                            name     => 'video_bk_all_hits',
                            type     => 'INT',
                            unsigned => TRUE,
                            not_null => TRUE,
                            default  => 0
                        },

                        {
                            name     => 'bk_price_w_nds',
                            type     => 'BIGINT',
                            unsigned => TRUE,
                            not_null => TRUE,
                            default  => 0
                        },
                        {
                            name     => 'bk_price_wo_nds',
                            type     => 'BIGINT',
                            unsigned => TRUE,
                            not_null => TRUE,
                            default  => 0
                        },
                        {
                            name     => 'bk_partner_price_w_nds',
                            type     => 'BIGINT',
                            unsigned => TRUE,
                            not_null => TRUE,
                            default  => 0
                        },
                        {
                            name     => 'bk_partner_price_wo_nds',
                            type     => 'BIGINT',
                            unsigned => TRUE,
                            not_null => TRUE,
                            default  => 0
                        },
                    ],
                    primary_key => [qw(dt page_id block_id dsp_id currency_id publisher_id content_id clid)],
                    indexes     => [
                        {fields => [qw(page_id block_id dt)]},
                        {fields => [qw(dsp_id dt)]},
                        {
                            fields => [
                                qw(
                                  clid
                                  content_id
                                  content_name
                                  currency_id
                                  page_id
                                  publisher_id
                                  publisher_name
                                  )
                            ]
                        }
                    ],
                    foreign_keys => [[['page_id', 'block_id'] => $_ => ['page_id', 'id']],],
                  }
              } qw(video_an_site_instream video_an_site_inpage video_an_site_fullscreen)
        ),

        internal_genre => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'public_id',   type => 'VARCHAR',  length   => 32,   not_null => TRUE},
                {name => 'name',        type => 'VARCHAR',  length   => 255,  not_null => TRUE},
                {name => 'multistate',  type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => [qw(public_id)], unique => TRUE}],
        },

        partner_genre => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'site_id',},
                {name => 'modification_date', type => 'DATETIME', not_null => TRUE},
                {name => 'date',              type => 'DATE',     not_null => TRUE},
                {name => 'public_id',         type => 'VARCHAR',  length   => 32, not_null => TRUE},
                {name => 'name',              type => 'VARCHAR',  length   => 255, not_null => TRUE},
                {name => 'hits',              type => 'INT',      unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'source_id',         type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 1},
                {name => 'multistate',        type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => [qw(site_id public_id)], unique => TRUE}],
            foreign_keys => [[['site_id'] => video_an_site => ['id']],],
        },

        partner_and_internal_genre => {
            fields      => [{name => 'partner_id',}, {name => 'internal_id',}],
            primary_key => [qw(partner_id internal_id)],
            foreign_keys =>
              [[['partner_id'] => partner_genre => ['id']], [['internal_id'] => internal_genre => ['id']],],
        },

        internal_genre_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'internal_genre',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        partner_genre_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'partner_genre',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        video_stat_files => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'page_id',},
                {name => 'type',      type => 'VARCHAR', length   => 10, not_null => TRUE},
                {name => 'date',      type => 'DATE',    not_null => TRUE},
                {name => 'from_date', type => 'DATE'},
                {name => 'to_date',   type => 'DATE'},
                {name => 'modification_date', type => 'DATETIME',   not_null => TRUE},
                {name => 'data',              type => 'MEDIUMBLOB', not_null => TRUE},
                {name => 's3_key',            type => 'VARCHAR',    length   => 255,},
                {name => 's3_size',           type => 'BIGINT'},
            ],
            primary_key  => [qw(id)],
            foreign_keys => [[['page_id'] => video_an_site => ['id']],],
        },

        internal_content => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'name',        type => 'VARCHAR',  length   => 255,  not_null => TRUE},
                {name => 'type_id',},
                {name => 'brand_id',   type => 'BIGINT',  unsigned => TRUE,},
                {name => 'publisher',  type => 'VARCHAR', length   => 255, not_null => TRUE, default => ''},
                {name => 'multistate', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(id)],
            foreign_keys => [[['type_id'] => content_type => ['id']],],
        },

        dictionary_words => {
            fields => [
                {name => 'content_id', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'word',       type => 'VARCHAR', length   => 16,   not_null => TRUE},
            ],
            primary_key  => [qw(content_id word)],
            foreign_keys => [[['content_id'] => internal_content => ['id']],],
        },

        insignificant_words => {
            fields => [
                {name => 'id',   type => 'INT',     unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'word', type => 'VARCHAR', length   => 16,   not_null => TRUE},
            ],
            primary_key => [qw(id)],
        },

        partner_content => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'site_id',},
                {name => 'modification_date', type => 'DATETIME', not_null => TRUE},
                {name => 'date',              type => 'DATE',     not_null => TRUE},
                {name => 'public_id',         type => 'VARCHAR',  length   => 32, not_null => TRUE},
                {name => 'name',              type => 'VARCHAR',  length   => 255, not_null => TRUE},
                {name => 'internal_id',       type => 'BIGINT',   unsigned => TRUE,},
                {name => 'publisher',         type => 'VARCHAR',  length   => 255, not_null => TRUE, default => ''},
                {name => 'hits',              type => 'INT',      unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'referer',           type => 'VARCHAR',  length   => 255, not_null => TRUE, default => ''},
                {name => 'source_id',         type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 1},
                {name => 'multistate',        type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => [qw(site_id public_id)], unique => TRUE}],
            foreign_keys => [[['site_id'] => video_an_site => ['id']],],
        },

        internal_content_genres => {
            fields      => [{name => 'content_id',}, {name => 'genre_id',}],
            primary_key => [qw(content_id genre_id)],
            foreign_keys =>
              [[['content_id'] => internal_content => ['id']], [['genre_id'] => internal_genre => ['id']],],
        },

        partner_content_genres => {
            fields      => [{name => 'content_id',}, {name => 'genre_id',}],
            primary_key => [qw(content_id genre_id)],
            foreign_keys => [[['content_id'] => partner_content => ['id']], [['genre_id'] => partner_genre => ['id']],],
        },

        internal_content_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'internal_content',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        partner_content_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'partner_content',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        content_type => {
            fields => [
                {name => 'id',      type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'caption', type => 'VARCHAR', length   => 255,  not_null => TRUE, i18n          => TRUE},
            ],
            primary_key => [qw(id)],
        },

        content_brand => {
            fields => [
                {name => 'id',      type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'caption', type => 'VARCHAR', length   => 255,  not_null => TRUE},
            ],
            primary_key => [qw(id)],
        },
    }
);

TRUE;
