package Application::Model::PartnerDB::Widgets;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        widgets => {
            fields => [
                {name => 'user_id'},
                {name => 'json_widgets_settings', type => 'MEDIUMTEXT',},
                {name => 'json_default_deleted_ids', type => 'MEDIUMTEXT',},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => ['user_id'],
            foreign_keys => [[['user_id'] => users => ['id']]]
        },

        widgets_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'widgets',
            elem_table_pk => ['user_id'],
            with_opts     => TRUE
        },
    }
);

TRUE;
