package Application::Model::PartnerLogsDB;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

sub accessor {'partner_logs_db'}

sub shard_name_with_year_suffix {
    my $dt = curdate();
    return $_[0] . sprintf('_%04d', $dt->[0]);
}

sub shard_name_with_month_suffix {
    my $dt = curdate();
    return $_[0] . sprintf('_%04d_%02d', $dt->[0], $dt->[1]);
}

__PACKAGE__->meta(
    tables => {
        bk_edit_page => {
            type       => 'ShardedTable',
            shard_name => \&shard_name_with_year_suffix,
            fields     => [
                {name => 'id',      type => 'BIGINT',    unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'dt',      type => 'TIMESTAMP', not_null => TRUE},
                {name => 'page_id', type => 'INT',       unsigned => TRUE},
                {name => 'login',    type => 'VARCHAR', length => 255,  not_null => TRUE},
                {name => 'request',  type => 'MEDIUMBLOB'},
                {name => 'response', type => 'VARCHAR', length => 4096, not_null => TRUE},
                {name => 'error',    type => 'VARCHAR', length => 4096, not_null => TRUE},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(page_id dt)], unique => TRUE}],
            engine      => 'MyISAM',
        },
        email => {
            type       => 'ShardedTable',
            shard_name => \&shard_name_with_month_suffix,
            fields     => [
                {name => 'id',      type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'dt',      type => 'DATETIME', not_null => TRUE},
                {name => 'subject', type => 'VARCHAR',  length   => 1023},
                {name => 'last_send_successful', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'from',                 type => 'VARCHAR', length   => 1023},
                {name => 'to',                   type => 'VARCHAR', length   => 1023},
                {name => 'cc',                   type => 'VARCHAR', length   => 1023},
                {name => 'bcc',                  type => 'VARCHAR', length   => 1023},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(dt)]}, {fields => [qw(subject)]}, {fields => [qw(to)]},],
            engine      => 'MyISAM',
        },
        email_data => {
            type       => 'ShardedTable',
            shard_name => \&shard_name_with_month_suffix,
            fields     => [
                {name => 'email_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE,},
                {name => 'headers',  type => 'TEXT',   not_null => TRUE},
                {name => 'body',     type => 'TEXT',   not_null => TRUE},
            ],
            primary_key => [qw(email_id)],
            # не работает из-за шардирования
            # foreign_keys => [[['email_id'] => email => ['id']]],
            engine => 'MyISAM',
        },
        email_attachment => {
            type       => 'ShardedTable',
            shard_name => \&shard_name_with_month_suffix,
            fields     => [
                {name => 'id',           type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'email_id',     type => 'BIGINT',  unsigned => TRUE, not_null => TRUE,},
                {name => 'filename',     type => 'VARCHAR', length   => 1023, not_null => TRUE},
                {name => 'content_type', type => 'VARCHAR', length   => 31,   not_null => TRUE},
                {name => 'data', type => 'MEDIUMBLOB', not_null => TRUE},
            ],
            primary_key => [qw(id)],
            # не работает из-за шардирования
            #foreign_keys => [[['email_id'] => email => ['id']]],
            engine => 'MyISAM',
        },
    }
);

TRUE;
