package Application::Model::Product;

=encoding UTF-8

=cut

use qbit;
use Utils::HookStash;

use base qw(Application::Model::Common);

__PACKAGE__->register_rights(
    [
        {
            name        => 'Application::Model::Product',
            description => d_gettext('Right to manage RTB blocks on sites'),
            rights      => {view_search_filters__login => d_gettext('Right to view login'),}
        }
    ]
);

=head2 delete_field_by_rights

Удаляет ключи полей их хэша филдов, если нет соотв. права
В качестве права может передаваться маска
Одно право может удалять несколько ключей

    $app->delete_field_by_rights( $fields, {
        # <Право или маска под право>                     <Поля которые оно закрывает>
         'do_context_on_site_rtb_save_dsps'           => 'dsp_list',
         'context_on_site_campaign_view_field__owner' => [qw(owner_client_id)],
         'context_on_site_rtb_view_field__%s'         => [qw(comment blind)],
    });

=cut

sub delete_field_by_rights {
    my $self = shift;
    my $fields = shift || {
        #    <field_name> => ...,
    };
    my $fields_by_right = shift || {
        #   '..view_field__%s' => [qw( <field_name>, ... )],
    };

    foreach my $right_templ (keys %$fields_by_right) {
        my $fields_to_check = $fields_by_right->{$right_templ} // [];
        $fields_to_check = [$fields_to_check] unless ref($fields_to_check) eq 'ARRAY';

        foreach my $field_name (@$fields_to_check) {
            my $right_name = sprintf $right_templ, $field_name;

            delete $fields->{$field_name}
              unless $self->check_rights($right_name);
        }
    }

    return 1;
}

sub do_action {
    my ($self, $object, $action, %opts) = @_;
    $object = $self->_split_id($object) if $self->can('_split_id');

    return $self->SUPER::do_action($object, $action, %opts);
}

sub do_action_with_result {
    my ($self, $object, $action, %opts) = @_;

    $object = $self->_split_id($object) if $self->can('_split_id');

    return $self->SUPER::do_action_with_result($object, $action, %opts);
}

sub force_do_action {
    my ($self, $object, $action, %opts) = @_;

    $object = $self->_split_id($object) if $self->can('_split_id');

    return $self->SUPER::force_do_action($object, $action, %opts);
}

sub get {
    my ($self, $object, @data) = @_;

    $object = $self->_split_id($object) if $self->can('_split_id');

    return $self->SUPER::get($object, @data);
}

sub get_agreement_error_message {
    my ($self) = @_;

    if ($self->rbac->cur_user_is_internal()) {
        return gettext("You can't start this product because partner has invalid agreement");
    } else {
        return gettext("You can't start this product with your agreement");
    }
}

sub get_bk_state_name_by_multistate {
    my ($self, $multistate) = @_;

    my $state = "stopped";
    if ($self->check_multistate_flag($multistate, 'working')) {
        $state = "work";
    } elsif ($self->check_multistate_flag($multistate, 'testing')) {
        $state =
          (in_array($self->accessor, [qw(indoor outdoor)]))
          ? 'work'
          : 'test';
    } elsif ($self->accessor eq 'mobile_app_settings') {
        # with feature 'simple_inapp' page should be sent to BK as soon as it is added with option MockMode=1
        $state = 'work' unless $self->check_multistate_flag($multistate, 'stopped');
    }

    return $state;
}

sub maybe_do_action {
    my ($self, $object, $action, %opts) = @_;

    $object = $self->_split_id($object) if $self->can('_split_id');

    return $self->SUPER::maybe_do_action($object, $action, %opts);
}

sub get_fields_depends {{}}

sub make_fields_defaults {{}}

sub force_to_number {
    my ($self, $settings, $model_fields) = @_;

    if (ref($settings) eq 'HASH') {
        foreach my $field (keys(%$settings)) {
            if ($model_fields->{$field}{'type'}
                && defined($settings->{$field}))
            {

                my $type = $model_fields->{$field}{'type'};

                $settings->{$field} += 0
                  if $type eq 'number'
                      || ($type eq 'boolean' && ($settings->{$field} eq '0' || $settings->{$field} eq '1'));

                if (   $type eq 'array'
                    && $model_fields->{$field}{'sub_type'} eq 'number')
                {
                    foreach (@{$settings->{$field}}) {
                        $_ += 0;
                    }
                }
            }
        }
    } else {
        throw sprintf('Unknown type: %s', ref($settings));
    }
}

TRUE;
