package Application::Model::Product::AN::ContextOnSite::BlockTypes::Direct;

use base qw(Exporter Application::Model::Product::BlockTypes::Direct);

use qbit;

our @EXPORT_OK = qw(
  @FIELDS
  @COLOR_FIELDS
  @BOOLEAN_FIELDS
  direct_appearance_fields
  direct_block_types
  %DIRECT_BLOCKS
  );

our @FIELDS = qw(
  border_type
  title_font_size
  font_family
  font_size
  );

our @COLOR_FIELDS = qw(
  site_bg_color
  bg_color
  border_color
  header_bg_color
  title_color
  text_color
  url_color
  url_background_color
  hover_color
  sitelinks_color
  );

our @BOOLEAN_FIELDS = qw(
  border_radius
  no_sitelinks
  favicon
  links_underline
  images_first
  );

sub direct_block_types {
    my ($self) = @_;
    return $self->SUPER::direct_block_types();
}

our %DIRECT_BLOCKS;
foreach my $bt (@{__PACKAGE__->direct_block_types()}) {
    throw gettext('Block type has no id') unless exists($bt->{'id'});
    throw gettext('Block type with ID=%s is exists', $bt->{'id'}) if exists($DIRECT_BLOCKS{$bt->{'id'}});

    $DIRECT_BLOCKS{$bt->{'id'}} = $bt;
}

sub direct_appearance_fields {
    return (@FIELDS, @COLOR_FIELDS, @BOOLEAN_FIELDS);
}

TRUE;
