package Application::Model::Product::AN::ContextOnSite::Campaign::Mirrors;

use qbit;

use base qw(Application::Model::Product::AN::Mirrors);

sub accessor        {'context_on_site_mirrors'}
sub db_table_name   {'context_on_site_mirrors'}
sub page_model_name {'context_on_site_campaign'}

sub get_structure_model_accessors {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_accessors()},

        partner_db               => 'Application::Model::PartnerDB::ContextOnSite',
        context_on_site_campaign => 'Application::Model::Product::AN::ContextOnSite::Campaign',
    };
}

sub get_structure_rights_to_register {
    return [
        {
            name        => 'context_on_site_mirrors',
            description => d_gettext('Right to manage context campaigns mirrors'),
            rights      => {
                context_on_site_mirrors_add_without_check => d_gettext('Right to add mirror without check'),
                add_mirrors_without_moderation            => d_gettext('Right to add mirror without moderation'),
            }
        }
    ];
}

TRUE;
