package Application::Model::Product::AN::ContextOnSite::Campaign::YaCategories;

use qbit;

use Utils::Tree;

use Application::Model::DAC;
use base qw(
  Application::Model::DBManager::Base
  Application::Model::Statistics::_Utils::Money
  Application::Model::DAC
  );

sub accessor      {'context_on_site_ya_categories'}
sub db_table_name {'context_on_site_ya_categories'}

__PACKAGE__->model_accessors(
    partner_db               => 'Application::Model::PartnerDB',
    ya_categories            => 'Application::Model::YaCategories',
    api_http_gozora          => 'QBit::Application::Model::API::Yandex::HTTPGoZora',
    context_on_site_campaign => 'Application::Model::Product::AN::ContextOnSite::Campaign',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'context_on_site_ya_categories',
            description => d_gettext('Right to manage yacootools on context campaigns'),
            rights      => {
                context_on_site_ya_categories_view_all =>
                  d_gettext('Right to view all yacotools categories on context campaigns'),
            }
        }
    ]
);

__PACKAGE__->model_fields(
    campaign_id => {default => TRUE, db => TRUE, pk => TRUE},
    category_id => {default => TRUE, db => TRUE, pk => TRUE, type => 'number'},
    probability           => {db => TRUE},
    probability_formatted => {
        depends_on => ['probability'],
        get        => sub {
            my $coeff = $_[0]->model->money2float($_[1]->{'probability'} // '-');

            return $coeff ne '-' ? $coeff * 100 : $coeff;
        },
        default => TRUE,
        type    => 'number',
    },
    name => {
        depends_on => ['category_id'],
        get        => sub {
            return $_[0]->{'__YA_CATEGORIES__'}{$_[1]->{'category_id'}} // '';
        },
        type => 'string',
    },
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        campaign_id => {type => 'number', label => d_gettext('Campaign ID')},
        category_id => {type => 'number', label => d_gettext('Category ID')},
    }
);

sub pre_process_fields {
    my ($self, $fields, $result) = @_;

    my $category_ids = array_uniq(map {$_->{'category_id'} // ()} @$result);

    if ($fields->need('name')) {
        $fields->{'__YA_CATEGORIES__'} = {};

        foreach (@{$self->ya_categories->get_all(filter => {id => $category_ids})}) {
            $fields->{'__YA_CATEGORIES__'}{$_->{'id'}} = $_->{'name'};
        }
    }
}

sub query_filter {
    my ($self, $filter) = @_;

    $filter = $self->limit_filter_by_special($filter, 'campaign_id', 'context_on_site_campaign', 'page_id');

    return $filter;
}

sub get_categories_for_view {
    my ($self, $page_ids) = @_;

    my $categories = $self->get_all(
        fields   => [qw(campaign_id category_id probability_formatted)],
        filter   => {campaign_id => $page_ids},
        order_by => [['campaign_id'], ['probability', 1]]
    );

    my @result          = ();
    my %campaigns_count = ();
    foreach (@$categories) {
        next if ++$campaigns_count{$_->{'campaign_id'}} > 5;

        push(@result, $_);
    }

    my $all_categories = $self->ya_categories->get_all();

    my $tree = get_tree_by_array($all_categories);

    my %categories_names = ();

    $tree->traverse(
        sub {
            my ($element) = @_;

            my $value = $element->getNodeValue();

            $value->{'name'} = $element->getParent->getNodeValue()->{'name'} . " | $value->{'name'}"
              if defined($element->getParent->getNodeValue()->{'name'});

            $categories_names{$value->{'id'}} = $value->{'name'};
        }
    );

    foreach (@result) {
        $_->{'name'} = $categories_names{$_->{'category_id'}};
    }

    return \@result;
}

TRUE;
