package Application::Model::Product::AN::ContextOnSite::Content;

use qbit;

use base qw(
  Application::Model::Block::External::Content
  );

consume qw(
  Application::Model::Role::Block::Has::ContentWidget
  Application::Model::Role::Block::Has::InitUniqueId
  Application::Model::Role::Block::Has::MetricaReports
  );

sub accessor      {'context_on_site_content'}
sub db_table_name {'context_on_site_content'}

sub get_campaign_model_name {
    return 'context_on_site_campaign';
}

sub get_product_name {gettext('context_on_site_content')}

sub public_id_prefix {'C-A-'}

sub get_structure_model_accessors {
    my ($class) = @_;

    return {%{$class->SUPER::get_structure_model_accessors()}, video_an_site => 'Application::Model::Page::Video',};
}

sub is_block_table_with_multiple_models {TRUE}

sub api_available_actions {
    my ($self) = @_;

    my @actions = qw(
      edit
      delete
      restore
      duplicate
      );

    return @actions;
}

TRUE;
