package Application::Model::Product::AN::ContextOnSite::MCB;

use qbit;

use base qw(
  Application::Model::Block::External::Site
  );

use QBit::Validator;

sub accessor                {'context_on_site_mcb'}
sub db_table_name           {'context_on_site_mcb'}
sub get_campaign_model_name {return 'context_on_site_campaign';}
sub get_product_name        {gettext('context_on_site_mcb')}
sub get_page_id_field_name  {'campaign_id'}
sub public_id_prefix        {'C-A-'}

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            name        => 'context_on_site_mcb',
            description => d_gettext('Right to manage MCB blocks on context campaigns'),
            rights      => {
                context_on_site_mcb_view_all => d_gettext('Right to view all MCB blocks on statistics'),
                context_on_site_mcb_view_action_log =>
                  d_gettext('Right to view MCB blocks action logs on context campaigns'),
                context_on_site_mcb_view_zero_block => d_gettext('Right to view zero context MCB blocks'),
                context_on_site_mcb_view => d_gettext('Right to view MCB blocks on context campaigns in menu'),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_fields()},
        caption => {
            depends_on => ['domain'],
            get        => sub {
                $_[1]->{'domain'};
            },
        },
        type    => {db => TRUE, label => d_gettext('Block format')},
        actions => {
            label      => d_gettext('Actions'),
            depends_on => [qw(id campaign_id multistate campaign)],
            get        => sub {
                $_[0]->model->get_actions($_[1]);
            },
        },
        comment => {
            label        => d_gettext('Block\'s comment'),
            check_rights => $self->get_right('view_field__comment'),
            get          => sub {
                ''
            },
            type => 'string',
        },
        status => {
            depends_on => ['multistate'],
            get        => sub {
                return 'sync';
            },
            type => 'string',
        },
    };
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        [
            (
                $self->check_rights('view_search_filters__login')
                ? {name => 'campaign.owner.login', label => gettext('Login')}
                : ()
            ),
            (
                $self->check_rights('view_search_filters__user_type')
                ? {name => 'user_type', label => gettext('User type')}
                : ()
            ),
            {name => 'id',          label => gettext('Block ID')},
            {name => 'campaign_id', label => gettext('Page ID')},
        ],
        [
            {name => 'campaign.all_domain', label => gettext('Domain and mirror')},
            {name => 'multistate',          label => gettext('Status')},
        ],
    ];
}

sub get_structure_multistates_graph {
    my ($self) = @_;

    return {
        empty_name  => d_pgettext('Block multistate', 'New'),
        multistates => [
            [deleted          => d_pgettext('Block multistate', 'Archived')],
            [check_statistics => d_pgettext('Block multistate', 'Check statistics')],
        ],
        actions => {
            set_check_statistics   => d_pgettext('Block action', 'Set "check_statistics"'),
            reset_check_statistics => d_pgettext('Block action', 'Reset "check_statistics"'),
            delete                 => d_pgettext('Block action', 'Archive'),
            restore                => d_pgettext('Block action', 'Restore'),
        },
        multistate_actions => [
            {
                action    => 'set_check_statistics',
                from      => '__EMPTY__ or not __EMPTY__',
                set_flags => ['check_statistics'],
            },
            {
                action      => 'reset_check_statistics',
                from        => 'check_statistics',
                reset_flags => ['check_statistics'],
            },
            {
                action    => 'delete',
                from      => 'not deleted',
                set_flags => ['deleted'],
            },
            {
                action      => 'restore',
                from        => 'deleted',
                reset_flags => ['deleted']
            },
        ],
    };
}

sub get_need_update_in_bk_fields {
    return {};
}

sub query_filter {
    my ($self, $filter) = @_;

    $filter = $self->limit_filter_by_campaign($filter);
    $filter = $self->limit_filter_view_zero_block($filter);

    return $filter;
}

sub get_bk_common_data {
    my ($self, $blocks) = @_;
    return (places => {755 => $blocks->[0]->{'type'} || '240x400'});
}

TRUE;
