package Application::Model::Product::AN::MobileApp::BlockTypes::Settings;

use base qw(Exporter);

use qbit;

use Hash::Util qw(lock_hash);
use PiConstants
  qw($BLOCK_TYPE_INTERSTITIAL $BLOCK_TYPE_BANNER $BLOCK_TYPE_NATIVE $BLOCK_TYPE_REWARDED $BLOCK_TYPE_ADAPTIVE_BANNER);

our @EXPORT_OK = qw(
  @BLOCK_TYPES
  %BLOCK_TYPES
  );

sub fix_template_for_interstitial_and_reward {
    my ($qv) = @_;

    my $fields = $qv->template->{'fields'};

    # для формата 320x480 эти поля находятся в skip_fields поэтому они перезатираются в fix_template...
    # + добавляется optional

    # Если бы был отдельный формат со своими skip_fields этот fix был бы не нужен
    $fields->{'font_size'}            = {eq   => undef,     optional => TRUE};
    $fields->{'title_font_size'}      = {eq   => undef,     optional => TRUE};
    $fields->{'font_family'}          = {eq   => undef,     optional => TRUE};
    $fields->{'url_background_color'} = {eq   => undef,     optional => TRUE};
    $fields->{'border_radius'}        = {type => 'boolean', optional => TRUE};
    $fields->{'border_type'} = {in => [qw(none block ad collapse)], optional => TRUE};
    $fields->{'sitelinks_color'} = {type => 'color', optional => TRUE};

    # show_video, adaptive_width/height не опциональные так как есть дефолт в базе...
    foreach (qw(limit media_block direct_block no_sitelinks favicon callouts)) {
        $fields->{$_}{'optional'} = TRUE;
    }
}

sub fix_template_for_native {
    my ($qv) = @_;

    my $fields = $qv->template->{'fields'};

    $fields->{'limit'} = {eq => undef, optional => TRUE}
      unless $qv->data->{'show_slider'};

    # show_video, adaptive_width/height не опциональные так как есть дефолт в базе...
    foreach (qw(media_block direct_block no_sitelinks favicon callouts)) {
        $fields->{$_}{'optional'} = TRUE;
    }
}

my @READ_ONLY_FIELDS = qw(
  direct_block
  media_block
  adaptive_width
  adaptive_height
  favicon
  no_sitelinks
  );

my $INTERSTITIAL_AND_REWARD_DEFAULTS = {
    'direct_block' => '320x480',
    'media_block'  => '320x480',
    'dsp_blocks'   => [qw(320x480 480x320 240x400 400x240 300x250 300x300)],
    'favicon'      => 0,
    'no_sitelinks' => 0,
    'show_video'   => 1,
};

our @BLOCK_TYPES = (
    {
        id               => $BLOCK_TYPE_BANNER,
        label            => d_gettext('block_type_banner'),
        label_stat       => d_gettext('stat_block_type_banner'),
        read_only_fields => [],
        skip_fields      => [qw(currency_type currency_value callback sign)],
        defaults         => {'show_video' => 1,},
        fix_template     => sub { },
    },
    {
        id               => $BLOCK_TYPE_INTERSTITIAL,
        label            => d_gettext('block_type_interstitial'),
        label_stat       => d_gettext('stat_block_type_inapp_interstitial'),
        read_only_fields => [qw(limit), @READ_ONLY_FIELDS],
        skip_fields      => [qw(currency_type currency_value callback sign rich_media)],
        defaults         => $INTERSTITIAL_AND_REWARD_DEFAULTS,
        fix_template     => \&fix_template_for_interstitial_and_reward,
    },
    {
        id               => $BLOCK_TYPE_NATIVE,
        label            => d_gettext('block_type_native'),
        label_stat       => d_gettext('stat_block_type_native'),
        read_only_fields => [qw(callouts), @READ_ONLY_FIELDS],
        skip_fields      => [qw(currency_type currency_value callback sign)],
        defaults         => {
            'direct_block' => 'native',
            'media_block'  => 'native',
            'dsp_blocks'   => [qw(native)],
            'favicon'      => 0,
            'no_sitelinks' => 0,
            'show_video'   => 0,
        },
        fix_template => \&fix_template_for_native,
    },
    {
        id               => $BLOCK_TYPE_REWARDED,
        label            => d_gettext('block_type_rewarded'),
        label_stat       => d_gettext('stat_block_type_rewarded'),
        read_only_fields => [qw(show_video limit dsp_blocks), @READ_ONLY_FIELDS],
        skip_fields      => [qw(rich_media)],
        defaults         => $INTERSTITIAL_AND_REWARD_DEFAULTS,
        fix_template     => \&fix_template_for_interstitial_and_reward,
    },
    {
        id               => $BLOCK_TYPE_ADAPTIVE_BANNER,
        label            => d_gettext('block_type_adaptive_banner'),
        label_stat       => d_gettext('stat_block_type_adaptive_banner'),
        read_only_fields => [],
        skip_fields      => [qw(currency_type currency_value callback sign rich_media)],
        defaults         => {'show_video' => 0,},
        fix_template     => sub { },
    },
);

our %BLOCK_TYPES = map {$_->{'id'} => $_} @BLOCK_TYPES;

lock_hash(%BLOCK_TYPES);

TRUE;
