package Application::Model::Product::AN::SearchOnSite::BlockTypes::Premium;

use qbit;

use base qw(Exporter);
our @EXPORT_OK = qw(
  direct_block_types
  @FIELDS
  @COLOR_FIELDS
  direct_appearance_fields
  @BOOLEAN_FIELDS
  %DIRECT_BLOCKS
  );

our @FIELDS = qw(
  border_type
  title_font_size
  font_family
  font_size
  );

our @COLOR_FIELDS = qw(
  site_bg_color
  header_bg_color
  title_color
  text_color
  url_color
  hover_color
  bg_color
  border_color
  sitelinks_color
  );

our @BOOLEAN_FIELDS = qw(
  favicon
  no_sitelinks
  border_radius
  links_underline
  );

sub direct_block_types {
    my ($self) = @_;
    return [
        {
            id                 => 'vertical',
            caption            => d_gettext('Vertical (1-3 banners)'),
            constuctor_caption => sub {ngettext('Vertical (%s banner)', 'Vertical (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 3,
        },
    ];
}

our %DIRECT_BLOCKS;
foreach my $bt (@{__PACKAGE__->direct_block_types()}) {
    throw gettext('Block type has no id') unless exists($bt->{'id'});
    throw gettext('Block type with ID=%s is exists', $bt->{'id'}) if exists($DIRECT_BLOCKS{$bt->{'id'}});

    $DIRECT_BLOCKS{$bt->{'id'}} = $bt;
}

sub direct_appearance_fields {
    return (@FIELDS, @COLOR_FIELDS, @BOOLEAN_FIELDS);
}

TRUE;
