package Application::Model::Product::Articles;

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'articles'}
sub db_table_name {'articles'}

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->register_rights($self->get_structure_rights_to_register());
    $self->model_fields($self->get_structure_model_fields());
    $self->model_filter($self->get_structure_model_filter());
}

sub get_structure_model_accessors {
    my ($class) = @_;

    return {partner_db => 'Application::Model::PartnerDB',};
}

sub get_structure_rights_to_register {
    return [];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        page_id     => {db => TRUE, default => TRUE, type => 'number',},
        block_id    => {db => TRUE, default => TRUE, type => 'number',},
        article_sid => {db => TRUE, default => TRUE, type => 'number',},
        cpm         => {
            db   => TRUE,
            type => 'number',
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        db_accessor => 'partner_db',
        fields      => {
            page_id     => {type => 'number',},
            block_id    => {type => 'number',},
            article_sid => {type => 'number',},
            cpm         => {type => 'number',},
        },
    };
}

sub replace {
    my ($self, $filter, $articles, $mode) = @_;

    throw Exception::Denied gettext("You can't save articles")
      unless $self->check_short_rights('edit');

    for my $article (@$articles) {
        $article->{article_sid} = delete $article->{id};
    }

    $self->partner_db->transaction(
        sub {
            $self->partner_db_table()->delete($self->partner_db->filter($filter)) if $mode eq 'edit';

            $self->partner_db_table()->add_multi(
                [
                    map {
                        {%$filter, %$_}
                      } @$articles
                ]
            );
        }
    );
}

sub remove_lost_articles {
    my ($self, $lost_sids) = @_;

    $self->partner_db_table()
      ->delete($self->partner_db->filter([OR => [map {[article_sid => '=' => \$_]} @$lost_sids]]));
}

TRUE;
