package Application::Model::Product::BlockTypes::Direct;

use qbit;

our @SKIP_FIELDS = qw(
  limit
  font_size
  title_font_size
  font_family
  url_background_color
  );

our @SKIP_FIELDS_WITHOUT_LIMIT = grep {$_ ne 'limit'} @SKIP_FIELDS;

sub direct_block_types {
    my ($self) = @_;
    return [
        {
            id                 => 'horizontal',
            caption            => d_gettext('Horizontal (to 4 banners)'),
            constuctor_caption => sub {ngettext('Horizontal (%s banner)', 'Horizontal (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 4,
            skip_fields        => [
                qw(
                  font_family
                  hover_color
                  sitelinks_color
                  title_color
                  title_font_size
                  url_background_color
                  url_color
                  )
            ],
        },
        {
            id                 => 'vertical',
            caption            => d_gettext('Vertical (1-9 banners)'),
            constuctor_caption => sub {ngettext('Vertical (%s banner)', 'Vertical (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 9,
        },
        {
            id                 => 'grid',
            caption            => d_gettext('Grid (4 banners)'),
            constuctor_caption => d_gettext('Grid (4 banners)'),
            banners            => 4,
            skip_fields        => [
                qw(
                  limit
                  url_background_color
                  )
            ],
        },

        {
            id                 => '160x600',
            caption            => d_gettext('160×600 (to 2 banners)'),
            constuctor_caption => sub {ngettext('160×600 (%s banner)', '160×600 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 2,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
        },
        {
            id                 => '240x400',
            caption            => d_gettext('240×400 (to 2 banners)'),
            constuctor_caption => sub {ngettext('240×400 (%s banner)', '240×400 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 2,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
        },
        {
            id                 => '200x300',
            caption            => d_gettext('200×300 (1 banner)'),
            constuctor_caption => sub {ngettext('200×300 (%s banner)', '200×300 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
        },

        {
            id                 => '300x300',
            caption            => d_gettext('300×300 (to 2 banners)'),
            constuctor_caption => sub {ngettext('300×300 (%s banner)', '300×300 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 2,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
        },
        {
            id                 => '300x250',
            caption            => d_gettext('300×250 (1 banner)'),
            constuctor_caption => sub {ngettext('300×250 (%s banner)', '300×250 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
        },
        {
            id                 => '250x250',
            caption            => d_gettext('250×250 (1 banner)'),
            constuctor_caption => sub {ngettext('250×250 (%s banner)', '250×250 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
        },

        {
            id                 => '728x90',
            caption            => d_gettext('728×90 (1 banner)'),
            constuctor_caption => sub {ngettext('728×90 (%s banner)', '728×90 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
        },
        {
            id                 => '1000x120',
            caption            => d_gettext('1000×120 (to 3 banners)'),
            constuctor_caption => sub {ngettext('1000×120 (%s banner)', '1000×120 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 3,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
        },
        {
            id      => 'posterVertical',
            caption => d_gettext('Vertical poster (1-9 banners)'),
            constuctor_caption =>
              sub {ngettext('Vertical poster (%s banner)', 'Vertical poster (%s banners)', $_[0], $_[0])},
            min_banners => 1,
            max_banners => 9,
            skip_fields => [
                qw(
                  font_size
                  border_type
                  border_radius
                  images_first
                  url_background_color
                  )
            ],
        },
        {
            id      => 'posterHorizontal',
            caption => d_gettext('Horizontal poster (1-4 banners)'),
            constuctor_caption =>
              sub {ngettext('Horizontal poster (%s banner)', 'Horizontal poster (%s banners)', $_[0], $_[0])},
            min_banners => 1,
            max_banners => 4,
            skip_fields => [
                qw(
                  font_size
                  border_type
                  border_radius
                  images_first
                  url_background_color
                  )
            ],
        },
        {
            id                 => 'adaptive',
            caption            => d_gettext('Adaptive (1-9 banners)'),
            constuctor_caption => sub {ngettext('Adaptive (%s banner)', 'Adaptive (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 9,
            skip_fields => [grep {$_ ne 'limit'} @SKIP_FIELDS],
        },
    ];
}

TRUE;
