package Application::Model::Product::BlockTypes::MobileAppRTB;

use qbit;

use base qw(Exporter);

our @EXPORT_OK = qw(
  direct_block_types
  @FIELDS
  @COLOR_FIELDS
  @BOOLEAN_FIELDS
  direct_appearance_fields
  %DIRECT_BLOCKS
  @MEDIA_BLOCKS
  %MEDIA_BLOCKS
  @DSP_BLOCKS
  %DSP_BLOCKS
  );

our @SKIP_FIELDS = qw(
  limit
  font_size
  title_font_size
  font_family
  callouts
  url_background_color
  );

our @SKIP_FIELDS_WITHOUT_LIMIT = grep {$_ ne 'limit'} @SKIP_FIELDS;

our @FIELDS = qw(
  border_type
  font_family
  font_size
  title_font_size
  );

our @COLOR_FIELDS = qw(
  site_bg_color
  bg_color
  border_color
  header_bg_color
  title_color
  text_color
  url_color
  url_background_color
  hover_color
  sitelinks_color
  );

our @BOOLEAN_FIELDS = qw(
  border_radius
  no_sitelinks
  favicon
  links_underline
  horizontal_align
  callouts
  );

sub direct_block_types {
    return [
        {
            id                 => '240x400',
            short_caption      => d_gettext('240×400'),
            caption            => d_gettext('240×400 (to 2 banners)'),
            constuctor_caption => sub {ngettext('240×400 (%s banner)', '240×400 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 2,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
            block_types        => [qw(interstitial)],
        },
        {
            id                 => '320x100',
            short_caption      => d_gettext('320×100'),
            caption            => d_gettext('320×100 (1 banner)'),
            constuctor_caption => sub {ngettext('320×100 (%s banner)', '320×100 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
            block_types        => [qw(banner)],
        },
        {
            id                 => '320x50',
            short_caption      => d_gettext('320×50'),
            caption            => d_gettext('320×50 (1 banner)'),
            constuctor_caption => sub {ngettext('320×50 (%s banner)', '320×50 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
            block_types        => [qw(banner)],
        },
        {
            id                 => '300x300',
            short_caption      => d_gettext('300×300'),
            caption            => d_gettext('300×300 (to 2 banners)'),
            constuctor_caption => sub {ngettext('300×300 (%s banner)', '300×300 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 2,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
            block_types        => [qw(banner interstitial)],
        },
        {
            id                 => '300x250',
            short_caption      => d_gettext('300×250'),
            caption            => d_gettext('300×250 (1 banner)'),
            constuctor_caption => sub {ngettext('300×250 (%s banner)', '300×250 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
            block_types        => [qw(banner interstitial)],
        },
        {
            id                 => '400x240',
            short_caption      => d_gettext('400×240'),
            caption            => d_gettext('400×240 (to 2 banners)'),
            constuctor_caption => sub {ngettext('400×240 (%s banner)', '400×240 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 2,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
            block_types        => [qw(interstitial)],
        },
        {
            id                 => '728x90',
            short_caption      => d_gettext('728×90'),
            caption            => d_gettext('728×90 (1 banner)'),
            constuctor_caption => sub {ngettext('728×90 (%s banner)', '728×90 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
            block_types        => [qw(banner)],
        },
        {
            id                 => '320x480',
            short_caption      => d_gettext('320×480'),
            caption            => d_gettext('320×480 (1 banner)'),
            constuctor_caption => sub {ngettext('320×480 (%s banner)', '320×480 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
            block_types        => [qw(interstitial rewarded)],
        },
        {
            id                 => '480x320',
            short_caption      => d_gettext('480×320'),
            caption            => d_gettext('480×320 (to 2 banners)'),
            constuctor_caption => sub {ngettext('480×320 (%s banner)', '480×320 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 2,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
            block_types        => [qw(interstitial)],
        },
        {
            id                 => 'horizontal',
            short_caption      => d_gettext('Horizontal'),
            caption            => d_gettext('Horizontal (to 4 banners)'),
            constuctor_caption => sub {ngettext('Horizontal (%s banner)', 'Horizontal (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 4,
            block_types        => [qw(banner)],
            skip_fields        => [
                qw(
                  font_family
                  hover_color
                  sitelinks_color
                  title_color
                  title_font_size
                  url_background_color
                  url_color
                  )
            ],
        },
        {
            id                 => 'vertical',
            short_caption      => d_gettext('Vertical'),
            caption            => d_gettext('Vertical (to 9 banners)'),
            constuctor_caption => sub {ngettext('Vertical (%s banner)', 'Vertical (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 9,
            block_types        => [qw(banner)],
        },
        {
            id                 => 'adaptive',
            short_caption      => d_gettext('Adaptive'),
            caption            => d_gettext('Adaptive (1-9 banners)'),
            constuctor_caption => sub {ngettext('Adaptive (%s banner)', 'Adaptive (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 9,
            skip_fields => [grep {$_ ne 'limit'} @SKIP_FIELDS],
            block_types => [qw(banner interstitial)],
        },
        {
            id                 => 'native',
            short_caption      => d_gettext('Native'),
            caption            => d_gettext('Native'),
            constuctor_caption => sub {gettext('Native')},
            banners            => 1,
            min_banners        => 1,
            max_banners        => 9,
            skip_fields =>
              [grep {!in_array($_, [qw/no_sitelinks favicon rich_media/])} (__PACKAGE__->direct_appearance_fields())],
            block_types => [qw(native)],
        },
        {
            id                 => 'adaptive0418',
            short_caption      => d_gettext('Adaptive banner'),
            caption            => d_gettext('Adaptive banner (1 banner)'),
            constuctor_caption => sub {gettext('Adaptive banner (1 banner)')},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
            block_types        => [qw(adaptive_banner banner)],
        },
    ];
}

our %DIRECT_BLOCKS = map {$_->{'id'} => $_} @{__PACKAGE__->direct_block_types()};

our @MEDIA_BLOCKS = (
    {id => '320x480', short_caption => d_gettext('320×480'), block_types => [qw(interstitial rewarded)]},
    {id => '480x320', short_caption => d_gettext('480×320'), block_types => [qw(interstitial)]},
    {id => '400x240', short_caption => d_gettext('400×240'), block_types => [qw(interstitial)]},
    {id => '240x400', short_caption => d_gettext('240×400'), block_types => [qw(interstitial)]},
    {id => '320x100', short_caption => d_gettext('320×100'), block_types => [qw(banner)]},
    {id => '320x50',  short_caption => d_gettext('320×50'),  block_types => [qw(banner)]},
    {id => '300x300', short_caption => d_gettext('300×300'), block_types => [qw(banner interstitial)]},
    {id => '300x250', short_caption => d_gettext('300×250'), block_types => [qw(banner interstitial)]},
    {id => '728x90',  short_caption => d_gettext('728×90'),  block_types => [qw(banner)]},
    {id => 'native',  short_caption => d_gettext('Native'),   block_types => [qw(native)], size => '0x0',},
    {
        id            => 'adaptive0418',
        short_caption => d_gettext('adaptive_banner'),
        block_types   => [qw(adaptive_banner banner)],
    },
);

our %MEDIA_BLOCKS = map {$_->{'id'} => $_} @MEDIA_BLOCKS;

our @DSP_BLOCKS = (
    {id => '320x480', short_caption => d_gettext('320×480'), block_types => [qw(interstitial rewarded)]},
    {id => '480x320', short_caption => d_gettext('480×320'), block_types => [qw(interstitial rewarded)]},
    {id => '400x240', short_caption => d_gettext('400×240'), block_types => [qw(interstitial rewarded)]},
    {id => '240x400', short_caption => d_gettext('240×400'), block_types => [qw(interstitial rewarded)]},
    {id => '320x100', short_caption => d_gettext('320×100'), block_types => [qw(banner native)]},
    {id => '320x50',  short_caption => d_gettext('320×50'),  block_types => [qw(banner native)]},
    {id => '300x300', short_caption => d_gettext('300×300'), block_types => [qw(banner interstitial rewarded native)]},
    {id => '300x250', short_caption => d_gettext('300×250'), block_types => [qw(banner interstitial rewarded native)]},
    {id => '728x90',  short_caption => d_gettext('728×90'),  block_types => [qw(banner native)]},
    {id => 'native',  short_caption => d_gettext('Native'),   block_types => [qw(native)], size => '0x0',},
    {
        id            => 'adaptive0418',
        short_caption => d_gettext('adaptive_banner'),
        block_types   => [qw(adaptive_banner banner)],
    },
);

our %DSP_BLOCKS = map {$_->{'id'} => $_} @DSP_BLOCKS;

sub direct_appearance_fields {
    return (@FIELDS, @COLOR_FIELDS, @BOOLEAN_FIELDS);
}

TRUE;
