package Application::Model::Product::BlockTypes::RTB;

use base qw(Exporter);

use qbit;

our @EXPORT_OK = qw(
  direct_block_types
  @FIELDS
  @COLOR_FIELDS
  @BOOLEAN_FIELDS
  direct_appearance_fields
  %DIRECT_BLOCKS
  @MEDIA_BLOCKS
  %MEDIA_BLOCKS
  @DSP_BLOCKS
  %DSP_BLOCKS
  );

our @FIELDS = qw(
  border_type
  font_family
  font_size
  title_font_size
  );

our @COLOR_FIELDS = qw(
  site_bg_color
  bg_color
  border_color
  header_bg_color
  title_color
  text_color
  url_color
  hover_color
  sitelinks_color
  );

our @BOOLEAN_FIELDS = qw(
  border_radius
  no_sitelinks
  favicon
  links_underline
  );

our @SKIP_FIELDS = qw(
  limit
  font_size
  title_font_size
  font_family
  url_background_color
  );

our @SKIP_FIELDS_WITHOUT_LIMIT = grep {$_ ne 'limit'} @SKIP_FIELDS;

sub direct_block_types {
    my ($self) = @_;
    return [
        {
            id                 => '1000x120',
            short_caption      => d_gettext('1000×120'),
            caption            => d_gettext('1000×120 (to 3 banners)'),
            constuctor_caption => sub {ngettext('1000×120 (%s banner)', '1000×120 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 3,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
        },
        {
            id                 => '160x600',
            short_caption      => d_gettext('160×600'),
            caption            => d_gettext('160×600 (to 2 banners)'),
            constuctor_caption => sub {ngettext('160×600 (%s banner)', '160×600 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 2,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
        },
        {
            id                 => '240x400',
            short_caption      => d_gettext('240×400'),
            caption            => d_gettext('240×400 (to 2 banners)'),
            constuctor_caption => sub {ngettext('240×400 (%s banner)', '240×400 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 2,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
        },
        {
            id                 => '300x300',
            short_caption      => d_gettext('300×300'),
            caption            => d_gettext('300×300 (to 2 banners)'),
            constuctor_caption => sub {ngettext('300×300 (%s banner)', '300×300 (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 2,
            skip_fields        => [@SKIP_FIELDS_WITHOUT_LIMIT],
        },
        {
            id                 => '300x250',
            short_caption      => d_gettext('300×250'),
            caption            => d_gettext('300×250 (1 banner)'),
            constuctor_caption => sub {ngettext('300×250 (%s banner)', '300×250 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
        },
        {
            id                 => '320x50',
            short_caption      => d_gettext('320×50'),
            caption            => d_gettext('320×50 (1 banner)'),
            constuctor_caption => d_gettext('320×50 (1 banner)'),
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
        },
        {
            id                 => '320x100',
            short_caption      => d_gettext('320×100'),
            caption            => d_gettext('320×100 (1 banner)'),
            constuctor_caption => d_gettext('320×100 (1 banner)'),
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
        },
        {
            id                 => '728x90',
            short_caption      => d_gettext('728×90'),
            caption            => d_gettext('728×90 (1 banner)'),
            constuctor_caption => sub {ngettext('728×90 (%s banner)', '728×90 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
        },
        {
            id                 => '100%x120',
            short_caption      => d_gettext('100%×120'),
            caption            => d_gettext('100%×120 (to 4 banners)'),
            constuctor_caption => sub {ngettext('100%×120 (%s banner)', '100%×120 (%s banners)', $_[0], $_[0])},
            banners            => 4,
            skip_fields        => [@SKIP_FIELDS],
        },
        {
            id                 => '100%x90',
            short_caption      => d_gettext('100%×90'),
            caption            => d_gettext('100%×90 (to 2 banners)'),
            constuctor_caption => sub {ngettext('100%×90 (%s banner)', '100%×90 (%s banners)', $_[0], $_[0])},
            banners            => 1,
            skip_fields        => [@SKIP_FIELDS],
        },
        {
            id                 => 'grid',
            short_caption      => d_gettext('Grid'),
            caption            => d_gettext('Grid (to 4 banners)'),
            constuctor_caption => d_gettext('Grid (4 banners)'),
            banners            => 4,
            skip_fields        => [
                qw(
                  limit
                  )
            ],
        },
        # может быть вообще удалить все кроме vertical? ибо модуль используется только в
        # Application::Model::Block::AdblockRTB - нигде не используется
        # Application::Model::Product::AN::ContextOnSite::AdBlock - допустимы только вертикальные
        {
            id                 => 'horizontal',
            short_caption      => d_gettext('Horizontal'),
            caption            => d_gettext('Horizontal (to 4 banners)'),
            constuctor_caption => sub {ngettext('Horizontal (%s banner)', 'Horizontal (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 4,
            skip_fields        => [
                qw(
                  font_family
                  hover_color
                  sitelinks_color
                  title_color
                  title_font_size
                  url_background_color
                  url_color
                  )
            ],
        },
        {
            id                 => 'vertical',
            short_caption      => d_gettext('Vertical'),
            caption            => d_gettext('Vertical (to 9 banners)'),
            constuctor_caption => sub {
                ngettext('Vertical (%s banner)', 'Vertical (%s banners)', $_[0], $_[0]);
            },
            min_banners => 1,
            max_banners => 9,
        },
        {
            id                 => 'posterHorizontal',
            short_caption      => d_gettext('Horizontal poster'),
            caption            => d_gettext('Horizontal poster (to 4 banners)'),
            constuctor_caption => sub {
                ngettext('Horizontal poster (%s banner)', 'Horizontal poster (%s banners)', $_[0], $_[0]);
            },
            min_banners => 1,
            max_banners => 4,
            skip_fields => [
                qw(
                  font_size
                  border_type
                  border_radius
                  )
            ],
        },
        {
            id            => 'posterVertical',
            short_caption => d_gettext('Vertical poster'),
            caption       => d_gettext('Vertical poster (to 9 banners)'),
            constuctor_caption =>
              sub {ngettext('Vertical poster (%s banner)', 'Vertical poster (%s banners)', $_[0], $_[0])},
            min_banners => 1,
            max_banners => 9,
            skip_fields => [
                qw(
                  font_size
                  border_type
                  border_radius
                  )
            ],
        },
        {
            id                 => 'adaptive',
            short_caption      => d_gettext('Adaptive'),
            caption            => d_gettext('Adaptive (1-9 banners)'),
            constuctor_caption => sub {ngettext('Adaptive (%s banner)', 'Adaptive (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 9,
            skip_fields => [grep {$_ ne 'limit'} @SKIP_FIELDS],
        },
    ];
}

our %DIRECT_BLOCKS = map {$_->{'id'} => $_} @{__PACKAGE__->direct_block_types()};

our @MEDIA_BLOCKS = (
    {id => '1000x120', short_caption => d_gettext('1000×120')},
    {id => '160x600',  short_caption => d_gettext('160×600')},
    {id => '240x600',  short_caption => d_gettext('240×600')},
    {id => '240x400',  short_caption => d_gettext('240×400')},
    {id => '300x600',  short_caption => d_gettext('300×600')},
    {id => '300x300',  short_caption => d_gettext('300×300')},
    {id => '300x250',  short_caption => d_gettext('300×250')},
    {id => '320x50',   short_caption => d_gettext('320×50')},
    {id => '320x100',  short_caption => d_gettext('320×100')},
    {id => '728x90',   short_caption => d_gettext('728×90')},
    {id => '100%x250', short_caption => d_gettext('100%×250')},
    {id => '100%x200', short_caption => d_gettext('100%×200')},
    {id => '100%x180', short_caption => d_gettext('100%×180')},
    {id => '100%x120', short_caption => d_gettext('100%×120')},
    {id => '100%x90',  short_caption => d_gettext('100%×90')},
);

our %MEDIA_BLOCKS = map {$_->{'id'} => $_} @MEDIA_BLOCKS;

our @DSP_BLOCKS = (
    {id => '1000x120', short_caption => d_gettext('1000×120')},
    {id => '160x600',  short_caption => d_gettext('160×600')},
    {id => '240x600',  short_caption => d_gettext('240×600')},
    {id => '240x400',  short_caption => d_gettext('240×400')},
    {id => '300x600',  short_caption => d_gettext('300×600')},
    {id => '300x300',  short_caption => d_gettext('300×300')},
    {id => '300x250',  short_caption => d_gettext('300×250')},
    {id => '320x50',   short_caption => d_gettext('320×50')},
    {id => '320x100',  short_caption => d_gettext('320×100')},
    {id => '728x90',   short_caption => d_gettext('728×90')},
    {id => '100%x250', short_caption => d_gettext('100%×250')},
    {id => '100%x200', short_caption => d_gettext('100%×200')},
    {id => '100%x180', short_caption => d_gettext('100%×180')},
    {id => '100%x120', short_caption => d_gettext('100%×120')},
    {id => '100%x90',  short_caption => d_gettext('100%×90')},
);

our %DSP_BLOCKS = map {$_->{'id'} => $_} @DSP_BLOCKS;

sub direct_appearance_fields {
    return (@FIELDS, @COLOR_FIELDS, @BOOLEAN_FIELDS);
}

TRUE;
