package Application::Model::Product::Brands;

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor        {'brands'}
sub db_table_name   {'brands'}
sub page_model_name {'context_on_site_campaign'}

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->register_rights($self->get_structure_rights_to_register());
    $self->model_fields($self->get_structure_model_fields());
    $self->model_filter($self->get_structure_model_filter());
}

sub get_structure_model_accessors {
    my ($class) = @_;

    return {partner_db => 'Application::Model::PartnerDB',};
}

sub get_structure_rights_to_register {
    return [];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        id       => {db => TRUE, default => TRUE, pk   => TRUE, type => 'string'},
        bid      => {db => TRUE, default => TRUE, type => 'number',},
        page_id  => {db => TRUE, default => TRUE, type => 'number',},
        block_id => {db => TRUE, default => TRUE, type => 'number',},
        blocked  => {db => TRUE, default => TRUE, type => 'boolean',},
        cpm      => {
            db         => TRUE,
            need_check => {optional => TRUE},
            type       => 'number',
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        db_accessor => 'partner_db',
        fields      => {
            bid      => {type => 'number',},
            page_id  => {type => 'number',},
            block_id => {type => 'number',},
            blocked  => {type => 'boolean',},
            cpm      => {type => 'number',},
        },
    };
}

sub replace {
    my ($self, $filter, $brands, $mode) = @_;

    # Специально Exception, а не Exception::Validation::BadArguments чтобы поймать письмо с неправильным вызовом
    throw Exception 'Incorrect filter' unless ref($filter) eq 'HASH';
    throw Exception 'No page_id'       unless defined($filter->{page_id});
    throw Exception 'No block_id'      unless defined($filter->{block_id});

    my $ids;
    $self->partner_db->transaction(
        sub {
            $self->partner_db_table()->delete($self->partner_db->filter($filter)) if $mode eq 'edit';

            $ids = $self->partner_db_table()->add_multi(
                [
                    map {
                        {
                            block_id => $filter->{block_id},
                            page_id  => $filter->{page_id},
                            bid      => $_->{bid},
                            blocked  => $_->{blocked},
                            cpm      => $_->{cpm},
                        }
                      } @$brands
                ],
                replace => 1
            );
        }
    );

    return $ids;
}

TRUE;
