package Application::Model::Product::InternalAN::InternalContextOnSite::BlockTypes::Direct;

use base qw(Exporter Application::Model::Product::BlockTypes::Direct);

use qbit;

our @EXPORT_OK = qw(
  direct_block_types
  @FIELDS
  @COLOR_FIELDS
  direct_appearance_fields
  %DIRECT_BLOCKS
  );

use Hash::Util qw(lock_hash);

our @FIELDS =
  qw(border_radius favicon border_type title_font_size no_sitelinks font_family font_size links_underline images_first);

our @COLOR_FIELDS =
  qw(site_bg_color bg_color border_color header_bg_color title_color text_color url_color url_background_color hover_color sitelinks_color);

sub direct_block_types {
    my ($self) = @_;
    return [
        @{$self->SUPER::direct_block_types()},
        {
            id                 => 'row',
            caption            => d_gettext('Row'),
            constuctor_caption => sub {gettext('Row')},
            banners            => 1,
            skip_fields        => [
                qw(
                  limit
                  url_background_color
                  )
            ],
        },
        {
            id                 => 'compact',
            caption            => d_gettext('Compact'),
            constuctor_caption => sub {gettext('Compact')},
            banners            => 1,
            skip_fields        => [
                qw(
                  limit
                  no_sitelinks
                  sitelinks_color
                  url_background_color
                  )
            ],
        },
    ];
}

our %DIRECT_BLOCKS;
foreach my $bt (@{__PACKAGE__->direct_block_types()}) {
    throw gettext('Block type has no id') unless exists($bt->{'id'});
    throw gettext('Block type with ID=%s is exists', $bt->{'id'}) if exists($DIRECT_BLOCKS{$bt->{'id'}});

    $DIRECT_BLOCKS{$bt->{'id'}} = $bt;
}

lock_hash(%DIRECT_BLOCKS);

sub direct_appearance_fields {
    return (@FIELDS, @COLOR_FIELDS);
}

TRUE;
