package Application::Model::Product::InternalAN::InternalContextOnSite::Natural;

use qbit;

use base qw(
  Application::Model::Block::Internal::Content
  );

consume qw(
  Application::Model::Role::Has::DSPS
  Application::Model::Role::Has::DSPS::WorkingOnAllPagesRule
  Application::Model::Role::Block::Has::ContentBlock
  Application::Model::Role::Block::Has::Tags
  Application::Model::Role::Block::Has::NaturalWidget
  Application::Model::Role::Has::CustomBKOptions
  Application::Model::Role::Block::Has::BlocksLimit
  );

sub accessor      {'internal_context_on_site_natural'}
sub db_table_name {'internal_context_on_site_natural'}

sub get_campaign_model_name {
    return 'internal_context_on_site_campaign';
}

sub get_product_name {gettext('internal_context_on_site_natural')}

sub public_id_prefix {'N-I-'}

sub get_opts_schema_name {'internal_context_on_site_natural_opts'}

sub get_save_dsps_right_name {'internal_context_on_site_natural_edit_field__dsps'}

sub turbo_desktop_available {TRUE}

sub site_versions_that_depend_on_feature {[]}

sub can_action_restore {
    my ($self, $block) = @_;

    my $object = $self->_get_object_fields($block, [qw(page)]);

    return $self->page->check_action($object->{'page'}, 'restore_block');
}

sub can_action_restore_with_page {
    my ($self, $block) = @_;

    return TRUE;
}

TRUE;
