package Application::Model::Product::InternalAN::InternalContextOnSite::RTB;

use qbit;

use base qw(
  Application::Model::Block::Internal::Site
  Application::Model::ValidatableMixin
  RestApi::MultistateModel
  );

use QBit::Validator;

use PiConstants qw(
  $DSP_MEDIA_TYPE_ID
  $FONT_SIZES
  $MIN_CPM_STRATEGY_ID
  $SITE_VERSIONS_TURBO
  $SITE_VERSIONS_TURBO
  $TECHNICAL_RTB_BLOCK_ID
  @INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS
  @VIDEO_AWAPS_DSPS
  );

use PiVariables qw(IGNORE_RTB_ON_DIRECT_SWITHER);

use Application::Model::Product::AN::ContextOnSite::BlockTypes::RTB qw(
  @BOOLEAN_FIELDS
  @MEDIA_BLOCKS
  %MEDIA_BLOCKS
  );

use Exception::Denied;
use Exception::Validation::BadArguments;
use Exception::Validator::Errors;
use Exception::Validator::Fields;

consume qw(
  Application::Model::Role::Block::Has::AdfoxBlock
  Application::Model::Role::Block::Has::InitUniqueId
  Application::Model::Role::Block::Has::MediaBlockCalculate
  Application::Model::Role::Block::Has::OnlyPortalTrustedBanners
  Application::Model::Role::Block::Has::PICategories
  Application::Model::Role::Block::Has::Tags
  Application::Model::Role::Block::Has::UnmoderatedDSPs
  Application::Model::Role::Has::Actions
  Application::Model::Role::Has::AvailableFields
  Application::Model::Role::Has::Block::DesignTemplates
  Application::Model::Role::Has::CreateDate
  Application::Model::Role::Has::CustomBKOptions
  Application::Model::Role::Has::DSPS::WorkingOnAllPagesRule
  Application::Model::Role::Has::EditableFields
  Application::Model::Role::Has::RTB
  Application::Model::Role::Has::ContextShowVideo
  Application::Model::Role::Has::SiteVersion
  Application::Model::Role::Has::Strategies::ShiftingFieldsContext
  Application::Model::Role::Has::Strategies::WithFilters
  Application::Model::Role::Block::Has::BlocksLimit
  Application::Model::Role::JavaJsonApiProxy
  );

sub accessor      {'internal_context_on_site_rtb'}
sub db_table_name {'internal_context_on_site_rtb'}

sub get_campaign_model_name {
    return 'internal_context_on_site_campaign';
}

sub get_product_name {gettext('internal_context_on_site_rtb')}

sub get_page_id_field_name {'campaign_id'}

sub public_id_prefix {'R-I-'}

sub get_dsp_type {[$DSP_MEDIA_TYPE_ID]}

sub get_video_dsp_list {
    return @INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS;
}

sub get_video_dsp_list_depends {()}

sub get_video_dsp_turn_on_block_filter {
    my ($self, $dsp) = @_;

    if (grep {$_ == $dsp->{id}} @VIDEO_AWAPS_DSPS, @INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS) {
        return [show_video => '=' => 1];
    } else {
        return;
    }
}

sub get_dsp_working_on_all_pages_multistate_name {
    'working_on_yandex_services'
}

sub role_show_video_get_fields_depends {[qw(show_video site_version)]}

sub get_opts_schema_name {'internal_context_on_site_rtb_opts'}

sub get_structure_model_accessors {
    my ($class) = @_;

    return {
        %{$class->SUPER::get_structure_model_accessors()},
        tns_dict_brand => 'Application::Model::TNSDict::Brand',
        dsp            => 'Application::Model::DSP',
        kv_store       => 'QBit::Application::Model::KvStore',
    };
}

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            name        => 'internal_context_on_site_rtb',
            description => d_gettext('Right to manage RTB blocks on internal sites'),
            rights      => {
                internal_context_on_site_rtb_view_all => d_gettext('Right to view all RTB blocks on internal sites'),
                internal_context_on_site_rtb_view_action_log =>
                  d_gettext('Right to view RTB blocks action logs on internal sites'),
                internal_context_on_site_rtb_view_zero_block =>
                  d_gettext('Right to view zero internal context RTB blocks'),
                internal_context_on_site_rtb_view => d_gettext('Right to view RTB blocks on internal sites in menu'),
                internal_context_on_site_rtb_view_field__comment =>
                  d_gettext('Right to view field comment of rtb blocks on internal context campaign'),
                internal_context_on_site_rtb_edit     => d_gettext('Right to edit RTB block to internal site'),
                internal_context_on_site_rtb_edit_all => d_gettext('Right to edit all RTB block to internal site'),
                internal_context_on_site_rtb_edit_field__blind =>
                  d_gettext('Right to edit field "blind" of RTB blocks on internal context campaign'),
                internal_context_on_site_rtb_edit_field__geo =>
                  d_gettext('Right to edit field "geo" of RTB blocks on internal context campaign'),
                view_technical_rtb_block => d_gettext('Right to view technical RTB block'),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_fields()},

        duplicate_direct => {db => TRUE, need_check => {type => 'boolean',}},

        horizontal_align => {db => TRUE, type => 'boolean', need_check => {type => 'boolean',}, api => 1},
        ex_direct        => {
            db         => TRUE,
            type       => 'boolean',
            need_check => {type => 'boolean', optional => TRUE}
        },
        active => {
            db         => TRUE,
            type       => 'boolean',
            need_check => {type => 'boolean', optional => TRUE}
        },
    };
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        {name => 'managers.manager.login', label => gettext('Manager\'s login')},
        {name => 'id',                     label => gettext('Block ID')},
        {name => 'campaign_id',            label => gettext('Page ID')},
        {name => 'caption',                label => gettext('Block\'s caption')},
        {name => 'campaign.all_domain',    label => gettext('Domain and mirror')},
        {name => 'multistate',             label => gettext('Status')},
    ];
}

sub get_structure_multistates_graph {
    my ($self) = @_;

    return {
        empty_name  => d_pgettext('Block multistate', 'New'),
        multistates => [
            [deleted           => d_pgettext('Block multistate', 'Archived')],
            [working           => d_pgettext('Block multistate', 'Working')],
            [check_statistics  => d_pgettext('Block multistate', 'Check statistics')],
            [deleted_with_page => d_pgettext('Block multistate', 'Archived with page'), private => TRUE],
            [need_update       => d_pgettext('Block multistate', 'Need update')],
            [updating          => d_pgettext('Block multistate', 'Updating')],
        ],
        actions => {
            edit                   => d_pgettext('Block action', 'Edit'),
            delete                 => d_pgettext('Block action', 'Archive'),
            delete_with_page       => d_pgettext('Block action', 'Archive with page'),
            restore_with_page      => d_pgettext('Block action', 'Restore with page'),
            start                  => d_pgettext('Block action', 'Start'),
            stop                   => d_pgettext('Block action', 'Stop'),
            set_check_statistics   => d_pgettext('Block action', 'Set "check_statistics"'),
            reset_check_statistics => d_pgettext('Block action', 'Reset "check_statistics"'),
            duplicate              => d_pgettext('Block action', 'Duplicate'),
        },
        right_name_prefix => $self->accessor . '_',
        right_actions     => {
            add     => d_pgettext('Block action', 'Add'),
            restore => d_pgettext('Block action', 'Restore'),
            set_need_update =>
              {label => d_pgettext('Block action', 'Set "need_update"'), dont_write_to_action_log => TRUE},
            start_update => {label => d_pgettext('Block action', 'Start update'), dont_write_to_action_log => TRUE},
            stop_update  => {label => d_pgettext('Block action', 'Stop update'),  dont_write_to_action_log => TRUE},
        },
        multistate_actions => [
            {
                action => 'add',
                from   => '__EMPTY__',
            },
            {
                action    => 'delete',
                from      => 'not deleted',
                set_flags => ['deleted'],
            },
            {
                action    => 'delete_with_page',
                from      => 'not deleted',
                set_flags => ['deleted_with_page', 'deleted'],
            },
            {
                action      => 'restore',
                from        => 'deleted and not deleted_with_page',
                reset_flags => ['deleted'],
            },
            {
                action      => 'restore_with_page',
                from        => 'deleted and deleted_with_page',
                reset_flags => ['deleted_with_page', 'deleted'],
            },
            {
                action => 'edit',
                from   => 'not deleted',
            },
            {
                action    => 'start',
                from      => 'not working and not deleted',
                set_flags => ['working'],
            },
            {
                action      => 'stop',
                from        => 'working',
                reset_flags => ['working'],
            },
            {
                action    => 'set_check_statistics',
                from      => 'not deleted',
                set_flags => ['check_statistics'],
            },
            {
                action      => 'reset_check_statistics',
                from        => 'check_statistics',
                reset_flags => ['check_statistics'],
            },
            {
                action => 'duplicate',
                from   => 'not (deleted or deleted_with_page)',
            },
            {
                action    => 'set_need_update',
                from      => '__EMPTY__ or not __EMPTY__',
                set_flags => ['need_update'],
            },
            {
                action      => 'start_update',
                from        => 'need_update',
                reset_flags => ['need_update'],
                set_flags   => ['updating'],
            },
            {
                action      => 'stop_update',
                from        => 'updating',
                reset_flags => ['updating'],
            },
        ],
    };
}

sub pre_process_fields {
    my ($self, $fields, $result) = @_;

    if ($fields->need('dsp_blocks')) {
        $fields->{'dsp_blocks'} = {};

        my $page_ids = $fields->stash->{'page_ids'} //= array_uniq(map {$_->{'page_id'}} @$result);

        foreach (
            @{
                $self->partner_db->media_sizes->get_all(
                    fields => [qw(page_id block_id type)],
                    filter => {page_id => $page_ids},
                )
            }
          )
        {
            push(@{$fields->{'dsp_blocks'}{$_->{'page_id'}, $_->{'block_id'}}}, $_->{'type'});
        }
    }
}

sub get_available_fields_depends {
    [qw(multistate id page)];
}

sub get_available_fields {
    my ($self, $obj) = @_;

    my $model_fields = $self->get_model_fields;
    my %fields = map {$_ => TRUE} keys(%$model_fields);

    delete(@fields{qw(active duplicate_direct ex_direct media_block)});

    my $accessor      = $self->accessor();
    my $page_accessor = $self->get_campaign_model_name();

    $self->app->delete_field_by_rights(
        \%fields,
        {
            # <Право или маска под право>            <Поля которые оно закрывает>
            $accessor . '_view_field__%s' => [qw(comment)],

            # campaign's right here!
            $page_accessor . '_view_field__manager' => 'manager_ids',
        }
    );

    return \%fields;
}

sub get_add_fields {
    my ($self, $object) = @_;

    my $fields = $self->_get_common_add_edit_fields();

    $fields->{'page_id'} = TRUE;

    $fields->{'comment'} = TRUE if $self->check_short_rights('view_field__comment');

    $self->set_show_video_add_fields($object, $fields);

    return $fields;
}

sub collect_editable_fields {
    my ($self, $data) = @_;

    my %res = %{$self->_get_common_add_edit_fields()};

    return \%res;
}

sub _get_common_add_edit_fields {
    my ($self) = @_;

    my $fields = $self->get_fields_by_right(
        no_right_fields => [
            qw(
              alternative_code
              caption
              dsp_blocks
              ),
            direct_appearance_fields(),
        ],
        right_fields => {
            edit => ['blind'],
            view => ['comment']
        }
    );

    return $fields;
}

sub add {
    my ($self, %opts) = @_;

    # удалить это после перехода фронта на page_id
    $opts{'page_id'} //= delete($opts{'campaign_id'});

    return $self->SUPER::add(%opts);
}

sub can_action_delete {
    my ($self, $obj) = @_;

    return TRUE;
}

sub can_action_duplicate {
    my ($self, $obj, %opts) = @_;

    return FALSE unless $self->check_rights($self->get_rights_by_actions('add'));

    my $object = $self->_get_object_fields($obj, [qw(is_protected)]);

    return !$object->{'is_protected'} || $self->check_rights('edit_protected_pages') ? TRUE : FALSE;
}

sub can_action_restore {
    my ($self, $block) = @_;

    my $object = $self->_get_object_fields($block, [qw(site_version page page_id)]);
    my $version_to_hide = $self->get_versions_to_hide($object->{page_id});

    return FALSE
      if $SITE_VERSIONS_TURBO->{$object->{'site_version'}} && !$object->{'page'}{'allowed_turbo'};

    return FALSE
      if $version_to_hide->{$object->{'site_version'}};

    return $self->page->check_action($object->{'page'}, 'restore_block');
}

sub can_action_restore_with_page {
    my ($self, $block) = @_;

    my $object = $self->_get_object_fields($block, [qw(site_version page)]);

    return FALSE
      if $SITE_VERSIONS_TURBO->{$object->{'site_version'}} && !$object->{'page'}{'allowed_turbo'};

    return TRUE;
}

sub on_action_restore_with_page {
    my ($self, $block) = @_;

    $self->SUPER::on_action_restore_with_page($block);

    my $object = $self->_get_object_fields($block, [qw(site_version page)]);
    my $version_to_hide = $self->get_versions_to_hide($object->{page});

    if ($version_to_hide->{$object->{'site_version'}}) {
        $self->maybe_do_action($block, 'delete');
    }
}

sub is_block_table_with_multiple_models {
    my ($self) = @_;

    return TRUE;
}

sub query_filter {
    my ($self, $filter) = @_;

    $filter = $self->limit_filter_by_campaign($filter);
    $filter = $self->limit_filter_view_zero_block($filter);
    $filter = $self->limit_filter_view_technical_rtb_block($filter);
    $filter = $self->limit_filter_active($filter);

    return $filter;
}

sub get_need_update_in_bk_fields {
    my ($self) = @_;

    my %fields_need_update = map {$_ => TRUE} qw(
      alternative_code
      dsp_blocks
      blind
      caption
      ), direct_appearance_fields();

    return \%fields_need_update;
}

sub api_available_fields {
    my ($self) = @_;

    my @fields = $self->SUPER::api_available_fields();

    # PI-27830 так как только в java сейчас делаем
    push @fields, 'pcode_settings';

    return sort @fields;
}

sub available_versions {qw(desktop mobile turbo turbo_desktop mobile_fullscreen mobile_rewarded mobile_floorad)}

sub boolean_fields {
    return {map {$_ => TRUE} @BOOLEAN_FIELDS};
}

sub direct_appearance_fields {
    return (@BOOLEAN_FIELDS);
}

sub fix_template {
    my ($self, $qv) = @_;

    $self->SUPER::fix_template($qv);

    my $template = $qv->template;
    my $fields   = $template->{'fields'};

    $self->fix_design_template($qv, $fields);

    $qv->template($template);
}

sub get_bk_block_data {
    my ($self, $block) = @_;

    my $bk_data = $self->get_bk_context_rtb_settings($block);

    #PI-10153
    # if ($block->{'direct_block'} eq 'modernAdaptive') {
    #    push(@{$bk_data->{'PageImpOptions'}{'Enable'}}, 'filter-sizes');
    #} else {
    push(@{$bk_data->{'PageImpOptions'}{'Disable'}}, 'filter-sizes');
    #}

    #PI-10760
    #if ($block->{'direct_block'} eq 'adaptive' || $block->{'direct_block'} eq 'modernAdaptive') {
    #    push(@{$bk_data->{'PageImpOptions'}{'Enable'}}, 'ignore-0x0-adaptive-sizes');
    #} else {
    push(@{$bk_data->{'PageImpOptions'}{'Disable'}}, 'ignore-0x0-adaptive-sizes');
    #}

    return $bk_data;
}

sub get_bk_block_data_key {'rtb_blocks'}

sub get_bk_common_data {
    return ();
}

sub get_cnt {
    my ($self, $arr_campaign_id) = @_;

    my $data = $self->partner_db->query->select(
        table  => $self->partner_db_table(),
        fields => {
            campaign_id => '',
            cnt         => {count => ['id']}
        },
        filter => [
            AND => [
                [campaign_id => 'IN'     => \$arr_campaign_id],
                [id          => '<>'     => \0],
                [id          => '<>'     => \$TECHNICAL_RTB_BLOCK_ID],
                [multistate  => 'NOT IN' => \$self->get_multistates_by_filter('deleted')],
                IGNORE_RTB_ON_DIRECT_SWITHER()
                ? ()
                : [active => '=' => \1]
            ]
        ],
    )->group_by('campaign_id')->get_all();

    return {map {$_->{'campaign_id'} => $_->{'cnt'}} @$data};
}

sub get_dsp_rules {
    my ($self) = @_;

    return [
        @{$self->SUPER::get_dsp_rules()}, $self->get_show_video_dsp_rule(),
        $self->get_working_on_all_pages_dsp_rule(),
    ];
}

sub get_filter_applicable_to_by_strategy {
    my ($self, $strategy_id) = @_;

    return ();
}

sub get_ad_type_list {
    my ($self, %opts) = @_;

    my @list = qw(media text);

    if (!exists($opts{is_video_applicable}) || $opts{is_video_applicable}) {
        push @list, 'video';
    }

    return \@list;
}

sub get_types_dsp_blocks {
    my ($self, $object, %opts) = @_;

    if ($opts{'filter_by_site_version'} && !$object->{'site_version'}) {
        throw Exception::Validation::BadArguments gettext('Expected "%s"', 'site_version');
    }

    my $media_blocks = clone(\@MEDIA_BLOCKS);

    my @result = ();
    foreach my $row (@$media_blocks) {
        if ($opts{'filter_by_site_version'}) {
            next unless grep {$object->{'site_version'} eq $_} @{$row->{'site_version'}};
        }

        $row->{'short_caption'} = $row->{'short_caption'}();

        push(@result, $row);
    }

    return \@result;
}

sub hook_fields_processing_before_validation {
    my ($self) = @_;

    my $opts    = $self->hook_stash->get('opts');
    my $current = $self->hook_stash->get('current');

    $self->SUPER::hook_fields_processing_before_validation($opts);
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $self->SUPER::hook_set_initialize_settings($opts);

    $self->partner_db->transaction(
        sub {
            $opts->{'id'} = $self->internal_context_on_site_campaign->get_next_block_id($opts->{'page_id'});
        }
    );
}

sub hook_preparing_fields_to_save {
    my ($self, $opts) = @_;

    #удалить после изменения схемы таблицы
    $opts->{'campaign_id'} = delete($opts->{'page_id'}) if exists($opts->{'page_id'});

    $self->SUPER::hook_preparing_fields_to_save($opts);
}

sub hook_save_fields_from_related_models {
    my ($self, $opts) = @_;

    my $id      = $self->hook_stash->get('id');
    my $related = $self->hook_stash->get('fields_from_related_models');
    my $mode    = $self->hook_stash->mode('add') ? 'add' : 'edit';

    if (my $dsp_blocks = $related->{'dsp_blocks'}) {
        $self->partner_db->media_sizes->delete(
            $self->partner_db->filter(
                {
                    page_id  => $id->{'campaign_id'},
                    block_id => $id->{'id'},
                }
            )
        ) if $mode eq 'edit';

        $self->partner_db->media_sizes->add_multi(
            [
                map +{
                    page_id  => $id->{'campaign_id'},
                    block_id => $id->{'id'},
                    type     => $_,
                },
                @$dsp_blocks,
            ]
        );
    }

    if (my $brands = $related->{'brands'}) {
        $self->brands->replace({page_id => $id->{'campaign_id'}, block_id => $id->{'id'}}, $brands, $mode);
    }
}

sub hook_processing_after_insert {
    my ($self, $opts) = @_;

    my $id = $self->hook_stash->get('id');

    $self->maybe_do_action($id, 'start');

    $self->update_in_bk($id);
}

sub hook_processing_after_update {
    my ($self, $opts) = @_;

    my $id = $self->hook_stash->get('id');

    $self->update_in_bk($id) if $self->need_update_in_bk($self->hook_stash->get('fields'));
}

sub get_actions_depends {
    [
        qw(
          id
          campaign_id
          page
          multistate
          is_my
          is_protected
          )
    ];
}

sub get_editable_fields_depends {
    [qw(page_id campaign_id id multistate is_my is_protected page)];
}

#API methods

sub api_available_actions {
    my ($self) = @_;

    my @actions = qw(
      duplicate
      edit
      delete
      restore
      );

    return @actions;
}

sub api_can_edit {TRUE}

sub api_can_add {TRUE}

sub get_fields_depends {
    return {
        #если поменялось поле из ключа, то
        #нужно перезапросить поля из значения
        depends => {
            page_id      => [qw(available_design_template_types dsps site_version)],
            show_video   => [qw(dsps available_design_template_types)],
            site_version => [qw(available_design_template_types dsp_blocks show_video)],
            id           => [qw(strategy)],
        },
        #для поля из ключа обязятельно нужно передать поля из значения
        required => {
            available_design_template_types => [qw(page_id site_version show_video)],
            dsp_blocks                      => [qw(site_version)],
            dsps                            => [qw(page_id show_video)],
            site_version                    => [qw(page_id)],
            strategy                        => [qw(id)],
            show_video                      => [qw(site_version)],
        },
    };
}

sub make_fields_defaults {
    my ($self, $opts, $need_fields) = @_;

    return $self->_rtb_make_fields_defaults($opts, $need_fields);
}

sub turbo_desktop_available {TRUE}

sub site_versions_that_depend_on_feature {[qw/mobile_fullscreen mobile_rewarded mobile_floorad/]}

sub default_site_version {'desktop'}

TRUE;
