package Application::Model::Product::InternalAN::InternalSearchOnSite::BlockTypes::Premium;

use base qw(Exporter);

use qbit;

our @EXPORT_OK = qw(
  direct_block_types
  @FIELDS
  @COLOR_FIELDS
  direct_appearance_fields
  %DIRECT_BLOCKS
  );

our @FIELDS =
  qw(favicon no_sitelinks border_type title_font_size font_family font_size border_radius links_underline adaptive_height);

our @COLOR_FIELDS =
  qw(site_bg_color header_bg_color title_color text_color url_color hover_color bg_color border_color sitelinks_color);

sub direct_block_types {
    my ($self) = @_;
    return [
        {
            id                 => 'horizontal',
            caption            => d_gettext('Horizontal (to 4 banners)'),
            constuctor_caption => sub {ngettext('Horizontal (%s banner)', 'Horizontal (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 4,
            skip_fields        => [
                qw(
                  font_family
                  hover_color
                  sitelinks_color
                  title_color
                  title_font_size
                  url_color
                  )
            ],
        },
        {
            id                 => 'vertical',
            caption            => d_gettext('Vertical (to 9 banners)'),
            constuctor_caption => sub {ngettext('Vertical (%s banner)', 'Vertical (%s banners)', $_[0], $_[0])},
            min_banners        => 1,
            max_banners        => 9,
            skip_fields        => [qw(adaptive_height)],
        },
    ];
}

our %DIRECT_BLOCKS;
foreach my $bt (@{__PACKAGE__->direct_block_types()}) {
    throw gettext('Block type has no id') unless exists($bt->{'id'});
    throw gettext('Block type with ID=%s is exists', $bt->{'id'}) if exists($DIRECT_BLOCKS{$bt->{'id'}});

    $DIRECT_BLOCKS{$bt->{'id'}} = $bt;
}

sub direct_appearance_fields {
    return (@FIELDS, @COLOR_FIELDS);
}

TRUE;
