package Application::Model::Product::Mirrors;

use qbit;

use base qw(Application::Model::DBManager::Base Application::Model::Common);

use Exception::Validation::BadArguments::InvalidMirror;
use Exception::DB::DuplicateEntry;
use Exception::Validation::BadArguments;
use Exception::Multistate::BadAction;

__PACKAGE__->abstract_methods(qw(add delete));

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->register_rights($self->get_structure_rights_to_register());
    $self->model_fields($self->get_structure_model_fields());
    $self->model_filter($self->get_structure_model_filter());
    $self->multistates_graph($self->get_structure_multistates_graph());
}

sub get_structure_model_accessors {
    return {api_http_gozora => 'QBit::Application::Model::API::Yandex::HTTPGoZora',};
}

sub get_structure_rights_to_register {
    return [];
}

sub get_structure_model_fields {
    return {};
}

sub get_structure_model_filter {
    return {};
}

sub get_structure_multistates_graph {
    return {};
}

sub check {
    my ($self, $campaign_id, $domain) = @_;

    $domain = get_domain_or_throw($domain);

    my $page_model = $self->page_model_name();

    my $fields = $self->get_model_fields();

    my $page_id_field_name = $page_model eq 'video_an_site' ? 'site_id' : 'campaign_id';

    my @current_mirrors =
      map {$_->{'domain'}} @{
        $self->get_all(
            fields => ['domain'],
            filter => {
                $page_id_field_name => $campaign_id,
                (exists($fields->{multistate}) ? (multistate => 'approved') : ())
            }
        )
      };

    $self->check_page_domain($campaign_id, $domain, @current_mirrors);

    return 1;
}

sub check_page_domain {
    my ($self, $campaign_id, $domain, @current_mirrors) = @_;

    my $page_model = $self->page_model_name();

    my $page_data = $self->$page_model->get($campaign_id, fields => ['domain']);

    throw Exception::Validation::BadArguments gettext('Incorrect Page ID: "%s"', $campaign_id)
      unless defined $page_data;

    my $main_domain = $page_data->{'domain'};

    foreach my $dd ($main_domain, @current_mirrors) {
        throw Exception::Validation::BadArguments gettext(
            "You should not add a subdomain as a mirror if a higher level domain is already added")
          if $domain =~ /\.$dd$/;
        throw Exception::Validation::BadArguments gettext('Mirror "%s" already exists', $domain)
          if $domain eq $dd;
    }

    unless ($self->check_rights('search_on_site_mirrors_add_without_check')) {
        throw Exception::Validation::BadArguments::InvalidMirror gettext('Mirror doesn\'t exist')
          unless $self->api_http_gozora->is_site_working($domain);
    }

    if ($self->app->site->is_rejected([$domain])) {
        throw Exception::Validation::BadArguments::InvalidMirror gettext(
            'Mirror cannot be added. Domain "%s" rejected.', $domain);
    }

    return 1;
}

TRUE;
