package Application::Model::Product::PICategories;

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'picategories'}
sub db_table_name {'picategories'}

sub get_structure_model_accessors {
    my ($class) = @_;

    return {partner_db => 'Application::Model::PartnerDB',};
}

sub get_structure_rights_to_register {
    return [];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        page_id     => {db => TRUE, default => TRUE, type => 'number',},
        block_id    => {db => TRUE, default => TRUE, type => 'number',},
        category_id => {db => TRUE, default => TRUE, type => 'number',},
        cpm         => {
            db   => TRUE,
            type => 'number',
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        db_accessor => 'partner_db',
        fields      => {
            page_id     => {type => 'number',},
            block_id    => {type => 'number',},
            category_id => {type => 'number',},
            cpm         => {type => 'number',},
        },
    };
}

sub replace {
    my ($self, $filter, $categoryes, $mode) = @_;

    throw Exception::Denied gettext("You can't save category")
      unless $self->check_short_rights('edit');

    for my $category (@$categoryes) {
        $category->{category_id} = delete $category->{id};
    }

    $self->partner_db->transaction(
        sub {
            $self->partner_db_table()->delete($self->partner_db->filter($filter)) if $mode eq 'edit';

            $self->partner_db_table()->add_multi(
                [
                    map {
                        {%$filter, %$_}
                      } @$categoryes
                ]
            );
        }
    );
}

sub remove_lost_category {
    my ($self, $lost_sids) = @_;

    $self->partner_db_table()
      ->delete($self->partner_db->filter([OR => [map {[category_id => '=' => \$_]} @$lost_sids]]));
}

TRUE;
