package Application::Model::Product::SSP::BlockTypes::RTB;

use qbit;

use Application::Model::Product::BlockTypes::MobileAppRTB qw(
  direct_block_types
  @FIELDS
  @COLOR_FIELDS
  @BOOLEAN_FIELDS
  direct_appearance_fields
  %DIRECT_BLOCKS
  @MEDIA_BLOCKS
  %MEDIA_BLOCKS
  );

our @ISA = qw(Application::Model::Product::BlockTypes::MobileAppRTB);

our @EXPORT_OK = qw(
  direct_block_types
  @FIELDS
  @COLOR_FIELDS
  @BOOLEAN_FIELDS
  direct_appearance_fields
  %DIRECT_BLOCKS
  @MEDIA_BLOCKS
  %MEDIA_BLOCKS
  @DSP_BLOCKS
  %DSP_BLOCKS
  );

our @DSP_BLOCKS = (
    {id => '240x600',  short_caption => d_gettext('240×600'),  block_types => [qw(interstitial)]},
    {id => '320x480',  short_caption => d_gettext('320×480'),  block_types => [qw(interstitial)]},
    {id => '480x320',  short_caption => d_gettext('480×320'),  block_types => [qw(interstitial)]},
    {id => '400x240',  short_caption => d_gettext('400×240'),  block_types => [qw(interstitial)]},
    {id => '240x400',  short_caption => d_gettext('240×400'),  block_types => [qw(interstitial)]},
    {id => '300x500',  short_caption => d_gettext('300×500'),  block_types => [qw(banner)]},
    {id => '300x600',  short_caption => d_gettext('300×600'),  block_types => [qw(banner)]},
    {id => '320x100',  short_caption => d_gettext('320×100'),  block_types => [qw(banner)]},
    {id => '320x50',   short_caption => d_gettext('320×50'),   block_types => [qw(banner)]},
    {id => '336x280',  short_caption => d_gettext('336×280'),  block_types => [qw(banner)]},
    {id => '300x300',  short_caption => d_gettext('300×300'),  block_types => [qw(banner interstitial)]},
    {id => '300x250',  short_caption => d_gettext('300×250'),  block_types => [qw(banner interstitial)]},
    {id => '728x90',   short_caption => d_gettext('728×90'),   block_types => [qw(banner)]},
    {id => '970x250',  short_caption => d_gettext('728×90'),   block_types => [qw(banner)]},
    {id => '1000x120', short_caption => d_gettext('1000×120'), block_types => [qw(banner)]},
    {id => 'native',   short_caption => d_gettext('Native'),    block_types => [qw(native)], size => '0x0',},
);

our %DSP_BLOCKS = map {$_->{'id'} => $_} @DSP_BLOCKS;

TRUE;
