package Application::Model::Product::SSP::ContextOnSite::Campaign;

use qbit;

use base qw(
  Application::Model::Page::SSP
  );

use Exception;
use Exception::Validation::BadArguments;

sub accessor              {'ssp_context_on_site_campaign'}
sub db_table_name         {'ssp_context_on_site_campaign'}
sub get_product_name      {gettext('ssp_context_on_site_campaign')}
sub get_block_model_names {['ssp_context_on_site_rtb']}
sub get_tmp_field_name    {'tmpl_ssp_context_rtb'}

sub get_structure_model_accessors {
    my ($class) = @_;

    return {
        %{$class->SUPER::get_structure_model_accessors()},
        ssp_site                              => 'Application::Model::Product::SSP::Site',
        ssp_context_on_site_rtb               => 'Application::Model::Product::SSP::ContextOnSite::RTB',
        ssp_context_on_site_campaign_mirrrors => 'Application::Model::Product::SSP::ContextOnSite::Campaign::Mirrors',
    };
}

sub get_structure_model_fields {
    my ($self) = @_;

    my $fields = {
        %{$self->SUPER::get_structure_model_fields()},
        domain_id    => {db => TRUE, db_expr => 'source_id'},
        product_type => {db => TRUE, db_expr => \'context'},
    };

    return $fields;
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        {name => 'page_id',           label => gettext('Page ID')},
        {name => 'ssp_source.domain', label => gettext('Domain')},
        {name => 'seller_id',         label => gettext('Seller name')},
        {name => 'multistate',        label => gettext('Status')}
    ];
}

sub get_right_name_to_view_all {'ssp_context_on_site_campaign_view_all'}

sub check_log_line {
    my ($self, $log) = @_;

    return $log->{'site_id'} && ($log->{'source_type'} eq 'media');
}

TRUE;
