package Application::Model::Product::SSP::ContextOnSite::RTB;

use qbit;

use base qw(Application::Model::Product::SSP::RTB);

use PiConstants qw($DSP_MEDIA_TYPE_ID);

sub accessor      {'ssp_context_on_site_rtb'}
sub db_table_name {'ssp_context_on_site_rtb'}

sub get_campaign_model_name {'ssp_context_on_site_campaign'}

sub get_opts_schema_name {'ssp_context_on_site_rtb_opts'}

sub get_product_name {gettext('ssp_context_on_site_rtb')}

sub public_id_prefix {'R-SA-'}

sub get_dsp_type {[$DSP_MEDIA_TYPE_ID]}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_fields},
        domain => {
            depends_on => [qw(page_id pages.domain)],
            get        => sub {
                return $_[0]->{'pages'}{$_[1]->{'page_id'}}{'domain'} // '';
            },
        }
    };
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        {name => 'campaign_id',            label => gettext('Page ID')},
        {name => 'page.ssp_source.domain', label => gettext('Domain')},
        {name => 'page.seller_id',         label => gettext('Seller ID')},
    ];
}

TRUE;
