package Application::Model::Product::SSP::Mirrors;

use qbit;

use base qw(Application::Model::Product::Mirrors);

use Exception::Validation::BadArguments::InvalidMirror;
use Exception::DB::DuplicateEntry;

sub get_structure_model_accessors {
    return {
        partner_db      => 'Application::Model::PartnerDB',
        api_http_gozora => 'QBit::Application::Model::API::Yandex::HTTPGoZora',
    };
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_fields()},

        campaign_id => {default => TRUE, db => TRUE, pk => TRUE},
        domain      => {default => TRUE, db => TRUE, pk => TRUE},
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_filter()},

        db_accessor => 'partner_db',
        fields      => {
            campaign_id => {type => 'number', label => d_gettext('Campaign ID')},
            domain      => {type => 'text',   label => d_gettext('Mirror')},
        },
    };
}

sub add {
    my ($self, $campaign_id, $domains) = @_;

    $domains = [
        map {
            get_domain($_, with_port => 1)
              // throw Exception::Validation::BadArguments::InvalidMirror gettext('Invalid mirror: "%s"', $_)
          } @$domains
    ];

    foreach (@$domains) {
        try {
            $self->partner_db_table()->add({campaign_id => $campaign_id, domain => $_});
        }
        catch Exception::DB::DuplicateEntry with {
            throw Exception::Validation::BadArguments::InvalidMirror gettext('Mirror "%s" is exists', $_);
        }
    }
    return $domains;
}

sub replace {
    my ($self, $obj, $mirrors) = @_;
    my %all_mirrors =
      map {$_->{domain} => TRUE} @{$self->get_all(fields => ['domain'], filter => {campaign_id => $obj->{id}})};
    my %new_mirrors     = map  {$_ => TRUE} @$mirrors;
    my @will_be_added   = grep {!$all_mirrors{$_}} keys %new_mirrors;
    my @will_be_deleted = grep {!$new_mirrors{$_}} keys %all_mirrors;
    $self->delete($obj->{id}, \@will_be_deleted);
    $self->add($obj->{id}, \@will_be_added);
}

sub delete {
    my ($self, $campaign_id, $domains) = @_;

    foreach (@$domains) {
        my $domain = get_domain($_)
          // throw Exception::Validation::BadArguments::InvalidMirror gettext('Invalid mirror: "%s"', $_);

        $self->partner_db_table()->delete({campaign_id => $campaign_id, domain => $domain});
    }
    return $domains;
}

TRUE;
