package Application::Model::Product::SSP::MobileApp::RTB;

use qbit;

use base qw(Application::Model::Product::SSP::RTB);

use PiConstants qw($DSP_MOBILE_TYPE_ID);

sub accessor      {'ssp_mobile_app_rtb'}
sub db_table_name {'ssp_mobile_app_rtb'}

sub get_campaign_model_name {'ssp_mobile_app_settings'}

sub get_opts_schema_name {'ssp_mobile_app_rtb_opts'}

sub get_product_name {gettext('ssp_mobile_app_rtb')}

sub public_id_prefix {'R-SM-'}

sub get_dsp_type {[$DSP_MOBILE_TYPE_ID]}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_fields},
        bundle_id => {
            depends_on => [qw(page_id pages.bundle_id)],
            get        => sub {
                return $_[0]->{'pages'}{$_[1]->{'page_id'}}{'bundle_id'} // '';
            },
        }
    };
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        {name => 'campaign_id',               label => gettext('Page ID')},
        {name => 'page.ssp_source.bundle_id', label => gettext('Bundle ID')},
        {name => 'page.seller_id',            label => gettext('Seller ID')},
    ];
}

TRUE;
