package Application::Model::Product::SSP::MobileApp::Settings;

use qbit;

use base qw(
  Application::Model::Page::SSP
  );

use Exception;
use Exception::Validation::BadArguments;

use PiConstants qw(
  $APP_TYPES
  );

sub accessor              {'ssp_mobile_app_settings'}
sub db_table_name         {'ssp_mobile_app_settings'}
sub get_product_name      {gettext('ssp_mobile_app_settings')}
sub get_block_model_names {['ssp_mobile_app_rtb']}
sub get_tmp_field_name    {'tmpl_ssp_mobile_app'}

sub get_structure_model_accessors {
    my ($class) = @_;

    return {
        %{$class->SUPER::get_structure_model_accessors()},
        ssp_application                 => 'Application::Model::Product::SSP::Application',
        ssp_mobile_app_rtb              => 'Application::Model::Product::SSP::MobileApp::RTB',
        ssp_mobile_app_settings_mirrors => 'Application::Model::Product::SSP::MobileApp::Settings::Mirrors',
    };
}

sub get_structure_model_fields {
    my ($self) = @_;

    my $fields = {
        %{$self->SUPER::get_structure_model_fields()},

        application => {
            depends_on => ['source_id'],
            get        => sub {
                $_[0]->{'ssp_source'}->{$_[1]->{'source_id'}};
              }
        },

        bundle_id => {
            depends_on => ['source_id', 'ssp_source.bundle_id'],
            get        => sub {
                $_[0]->{'ssp_source'}{$_[1]->{'source_id'}}{'bundle_id'};
            },
        },
        store_id => {
            depends_on => ['source_id', 'ssp_source.store_id'],
            get        => sub {
                $_[0]->{'ssp_source'}{$_[1]->{'source_id'}}{'store_id'};
            },
        },
        store => {
            depends_on => [qw(store_id)],
            get        => sub {
                $APP_TYPES->{$_[1]->{'store_id'}}{'store'};
            },
        },

        product_type => {db => TRUE, db_expr => \'mobile'},
    };

    return $fields;
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        {name => 'page_id',              label => gettext('Page ID')},
        {name => 'ssp_source.bundle_id', label => gettext('Bundle ID')},
        {name => 'seller_id',            label => gettext('Seller ID')},
        {name => 'multistate',           label => gettext('Status')},
    ];
}

sub get_bk_data {
    my ($self, $page) = @_;

    my %bk_data = $self->SUPER::get_bk_data($page);

    my $page_options = delete($bk_data{page_options});

    my %enabled = map {$_ => 1} @{$page_options->{Enable}};
    $page_options->{Enable} = [sort keys %enabled];

    my %data = (
        %bk_data,
        page_options => $page_options,
        store        => $page->{'store'},
        mobile_app   => TRUE,
    );

    return %data;
}

sub get_right_name_to_view_all {'ssp_mobile_app_settings_view_all'}

sub check_log_line {
    my ($self, $log) = @_;

    return $log->{'application_id'} && ($log->{'source_type'} eq 'app-media');
}

TRUE;
