package Application::Model::Product::SSP::Seller;

use qbit;

use Application::Model::DAC;
use base qw(
  Application::Model::DBManager::Base
  Application::Model::DAC
  );

sub accessor      {'ssp_seller'}
sub db_table_name {'ssp_seller'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB', users => 'Application::Model::Users');

__PACKAGE__->register_rights(
    [
        {
            name        => 'ssp_seller',
            description => d_gettext('Right to manage mobile applications'),
            rights      => {ssp_seller_view_all => d_gettext('Right to view all SSP sellers'),},
        }
    ]
);

__PACKAGE__->model_fields(
    id                   => {default => TRUE, db    => TRUE, pk => TRUE, label => d_gettext('ID')},
    user_id              => {db      => TRUE, label => d_gettext('Create date')},
    client_id            => {db      => TRUE,},
    name                 => {db      => TRUE,},
    tmpl_ssp_mobile_app  => {db      => TRUE,},
    tmpl_ssp_context_rtb => {db      => TRUE,},
    tmpl_ssp_video_app   => {db      => TRUE,},
    login                => {
        depends_on => ['user_id'],
        get        => sub {
            $_[0]->{'__USERS__'}{$_[1]->{'user_id'}}{'login'} // '';
          }
    },
    business_unit => {
        depends_on => ['user_id'],
        get        => sub {
            $_[0]->{'__USERS__'}{$_[1]->{'user_id'}}{'business_unit'};
          }
    }
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        id        => {type => 'number', label => d_gettext('ID')},
        user_id   => {type => 'number', label => d_gettext('User ID')},
        client_id => {type => 'number', label => d_gettext('User ID')},
        name      => {type => 'text',   label => d_gettext('Name')},
    }
);

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        [{name => 'id',        label => gettext('ID')},        {name => 'user_id', label => gettext('User ID')},],
        [{name => 'client_id', label => gettext('Client ID')}, {name => 'name',    label => gettext('Seller name')},],
    ];
}

sub pre_process_fields {
    my ($self, $fields, $result, %opts) = @_;

    if ($fields->need('login') || $fields->need('business_unit')) {
        my $tmp_rights = $self->app->add_tmp_rights('users_view_all', 'users_view_field__client_id');
        $fields->{'__USERS__'} = {
            map {$_->{'id'} => $_} @{
                $self->users->get_all(
                    fields => [qw(id login business_unit)],
                    filter => {id => array_uniq(map {$_->{'user_id'} // ()} @$result)},
                )
              }
        };
        undef($tmp_rights);
    }
}

sub query_filter {
    my ($self, $filter) = @_;

    $filter = $self->limit_filter_by_user($filter);

    return $filter;
}

sub get_adv_net_mobile_ssp_page_ids {
    my ($self) = @_;

    my $data = $self->app->partner_db->_get_all("
    select
        context_page_id,
        s.name,
        m.application_id
    from
        ssp_seller s,
        users u,
        mobile_app_settings m
    where
        u.client_id = s.client_id
        and u.id = m.owner_id
    order by
        context_page_id
    ;
");

    my @page_ids = map {$_->{'context_page_id'}} @$data;

    return @page_ids;
}

sub _db_table {$_[0]->partner_db->ssp_seller}

TRUE;
