package Application::Model::Product::SSP::Site;

use qbit;

use base qw(Application::Model::Product);

sub accessor      {'ssp_site'}
sub db_table_name {'ssp_site'}

__PACKAGE__->model_accessors(
    partner_db => 'Application::Model::PartnerDB',
    ssp_imps   => 'Application::Model::Product::SSP::ImpressionLog',
);

__PACKAGE__->model_fields(
    id     => {default => TRUE,                pk => TRUE, label => d_gettext('ID'), db => TRUE},
    domain => {label   => d_gettext('Domain'), db => TRUE},
    name   => {label   => d_gettext('Name'),   db => TRUE},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        id => {
            type  => 'number',
            label => d_gettext('ID'),
        },
        domain => {
            type  => 'text',
            label => d_gettext('Domain'),
        },
    }
);

sub find_by_imp {
    my ($self, $imp, %opts) = @_;

    throw 'Impression without data' unless $imp->{source_domain};

    my $domain_name = get_domain($imp->{source_domain}, www => FALSE);

    my $site = $self->partner_db->ssp_site->get_all(
        fields => [
            @{$opts{fields} || []},
            qw(
              id
              domain
              name
              )
        ],
        filter => {domain => $domain_name},
    );

    if ($site->[0]) {
        return $site->[0];
    } else {
        return $self->_create_from_imp($imp);
    }

}

sub _create_from_imp {
    my ($self, $imp, %opts) = @_;

    throw 'Impression without data' unless $imp->{source_domain};

    my $domain_name = get_domain($imp->{source_domain}, www => FALSE);

    return unless $domain_name;

    my $site_id = $self->partner_db->ssp_site->add(
        {
            domain => $domain_name,
            name   => '',
        }
    );

    return {id => $site_id};
}

TRUE;
