package Application::Model::Product::SSP::VideoAN::Site;

use qbit;

use base qw(
  Application::Model::Page::SSP
  );

use Exception;
use Exception::Validation::BadArguments;

use PiConstants qw(
  $APP_TYPES
  );

sub accessor              {'ssp_video_an_site'}
sub db_table_name         {'ssp_video_an_site'}
sub get_product_name      {gettext('ssp_video_an_site')}
sub get_block_model_names {['ssp_video_an_site_rtb']}
sub get_tmp_field_name    {'tmpl_ssp_video_app'}

sub get_structure_model_accessors {
    my ($class) = @_;

    return {
        %{$class->SUPER::get_structure_model_accessors()},
        ssp_site                  => 'Application::Model::Product::SSP::Site',
        ssp_video_an_site_rtb     => 'Application::Model::Product::SSP::VideoAN::Site::RTB',
        ssp_video_an_site_mirrors => 'Application::Model::Product::SSP::VideoAN::Site::Mirrors',
    };
}

sub get_structure_model_fields {
    my ($self) = @_;

    my $fields = {
        %{$self->SUPER::get_structure_model_fields()},

        application => {
            depends_on => ['source_id'],
            get        => sub {
                $_[0]->{'ssp_source'}->{$_[1]->{'source_id'}};
              }
        },

        bundle_id => {
            depends_on => ['source_id', 'ssp_source.bundle_id'],
            get        => sub {
                $_[0]->{'ssp_source'}{$_[1]->{'source_id'}}{'bundle_id'};
            },
        },
        store_id => {
            depends_on => ['source_id', 'ssp_source.store_id'],
            get        => sub {
                $_[0]->{'ssp_source'}{$_[1]->{'source_id'}}{'store_id'};
            },
        },
        store => {
            depends_on => [qw(store_id)],
            get        => sub {
                $APP_TYPES->{$_[1]->{'store_id'}}{'store'};
            },
        },

        product_type => {db => TRUE, db_expr => \'mobile'},
    };

    return $fields;
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        {name => 'page_id',              label => gettext('Page ID')},
        {name => 'ssp_source.bundle_id', label => gettext('Domain')},
        {name => 'seller_id',            label => gettext('Seller name')},
        {name => 'multistate',           label => gettext('Status')}
    ];
}

sub get_bk_data {
    my ($self, $page) = @_;

    my %bk_data = $self->SUPER::get_bk_data($page);

    my %data = (
        %bk_data,
        store      => $page->{'store'},
        mobile_app => TRUE,
    );

    return %data;
}

sub get_right_name_to_view_all {'ssp_video_an_site_view_all'}

sub check_log_line {
    my ($self, $log) = @_;

    return $log->{'application_id'} && ($log->{'source_type'} eq 'app-video');
}

TRUE;
