package Application::Model::Product::SSP::VideoAN::Site::RTB;

use qbit;

use base qw(Application::Model::Product::SSP::RTB);

use PiConstants qw($DSP_VIDEO_TYPE_ID);

sub accessor      {'ssp_video_an_site_rtb'}
sub db_table_name {'ssp_video_an_site_rtb'}

sub get_campaign_model_name {'ssp_video_an_site'}

sub get_opts_schema_name {'ssp_video_an_site_rtb_opts'}

sub get_product_name {gettext('ssp_video_an_site_rtb')}

sub public_id_prefix {'R-SV-'}

sub get_dsp_type {[$DSP_VIDEO_TYPE_ID]}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_fields},
        bundle_id => {
            depends_on => [qw(page_id pages.bundle_id)],
            get        => sub {
                return $_[0]->{'pages'}{$_[1]->{'page_id'}}{'bundle_id'} // '';
            },
        }
    };
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        {name => 'campaign_id',               label => gettext('Page ID')},
        {name => 'page.ssp_source.bundle_id', label => gettext('Bundle ID')},
        {name => 'page.seller_id',            label => gettext('Seller ID')},
    ];
}

TRUE;
