package Application::Model::Product::VideoAN::Site::Fullscreen;

use qbit;

use base qw(Application::Model::Block::Video);

use PiConstants qw(
  $INTERSTITIAL
  $VIDEO_PLATFORM_MOBILE
  $VIDEO_PLATFORM_SMART_TV
  );

consume qw(
  Application::Model::Role::Block::Has::AdfoxBlock
  );

sub accessor      {'video_an_site_fullscreen'}
sub db_table_name {'video_an_site_fullscreen'}

sub get_product_name {gettext('video_an_site_fullscreen')}

sub public_id_prefix {'R-VF-'}

sub get_structure_model_fields {
    my ($self) = @_;

    my $model_fields = $self->SUPER::get_structure_model_fields();

    delete @$model_fields{
        qw(
          is_tutby
          )
      };

    return $model_fields;
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        (
            $self->check_rights('view_search_filters__login')
            ? ({name => 'login', label => gettext('Login'), login_filter => 'video_an_partner=1'})
            : ()
        ),
        {name => 'page_id',     label => gettext('Page ID')},
        {name => 'category_id', label => gettext('Categories ID')},
        {name => 'id',          label => gettext('Block ID')},
        {name => 'caption',     label => gettext('Block\'s caption')},
        {name => 'page.domain', label => gettext('Resource')},
        {name => 'multistate',  label => gettext('Status')},
    ];
}

sub get_incompatible_platforms {
    return [$VIDEO_PLATFORM_SMART_TV];
}

sub get_types_ids {[$INTERSTITIAL]}

sub without_yandex_video_search {TRUE}

sub get_opts_schema_name {'video_an_site_fullscreen_opts'}

TRUE;
