package Application::Model::Product::VideoAN::Site::InPage;

use qbit;

use base qw(Application::Model::Block::Video);

consume qw(Application::Model::Role::Has::Preload
  Application::Model::Role::Block::Has::AdfoxBlock);

use PiConstants qw(
  $INPAGE
  $STICK_TO_VALID_VALUES
  $VIDEO_PLATFORM_MOBILE
  $VIDEO_PLATFORM_SMART_TV
  );

sub accessor      {'video_an_site_inpage'}
sub db_table_name {'video_an_site_inpage'}

sub get_opts_schema_name {'video_an_site_inpage_opts'}

sub get_product_name {gettext('video_an_site_inpage')}

sub public_id_prefix {'R-VI-'}

sub get_structure_model_fields {
    my ($self) = @_;

    my %model_fields = (
        %{$self->SUPER::get_structure_model_fields()},
        'auto_repeat' => {
            db         => TRUE,
            label      => d_gettext('Allow auto repeat video'),
            type       => 'boolean',
            api        => 1,
            need_check => {
                type  => 'boolean',
                check => sub {
                    my ($qv, $auto_repeat) = @_;

                    throw Exception::Validator::Fields gettext(
                        "Can't turn on auto repeat option while hide block at the end option is turned on")
                      if $qv->data->{'hide_at_the_end'} && $auto_repeat;
                  }
            },
            adjust_type => 'str',
        },
        'hide_at_the_end' => {
            db          => TRUE,
            label       => d_gettext('Allow hide block at the end of video'),
            type        => 'boolean',
            api         => 1,
            need_check  => {type => 'boolean',},
            adjust_type => 'str',
        },
        'light_color_scheme' => {
            from_opts  => 'from_hash',
            label      => d_gettext('Light color scheme'),
            type       => 'boolean',
            need_check => {
                type     => 'boolean',
                optional => TRUE,
                check    => sub {
                    my ($qv, $light_color_scheme) = @_;

                    throw Exception::Validator::Fields gettext(
                        "Can't set parameter \"%s\" while \"%s\" option is turned off",
                        'light_color_scheme', 'stick outstream')
                      if defined $light_color_scheme && !$qv->data->{'stick_outstream'};
                  }
            },
            api         => 1,
            adjust_type => 'str',
        },
        'stick_outstream' => {
            db         => TRUE,
            label      => d_gettext('Allow stick outstream'),
            type       => 'boolean',
            api        => 1,
            need_check => {
                type  => 'boolean',
                check => sub {
                    my ($qv, $stick_outstream) = @_;
                    my @fields;
                    if ($stick_outstream) {
                        foreach (qw(stick_to light_color_scheme)) {
                            push @fields, $_ unless defined $qv->data->{$_};
                        }
                    }

                    throw Exception::Validator::Fields gettext('Missing fields: %s', join(', ', @fields)) if @fields;
                  }
            },
            adjust_type => 'str',
        },
        'stick_to' => {
            from_opts  => 'from_hash',
            label      => d_gettext('Stick to'),
            type       => 'string',
            need_check => {
                type     => 'scalar',
                optional => TRUE,
                check    => sub {
                    my ($qv, $stick_to) = @_;

                    throw Exception::Validator::Fields gettext(
                        "Can't set parameter \"%s\" while \"%s\" option is turned off",
                        'stick_to', 'stick outstream')
                      if defined $stick_to && !$qv->data->{'stick_outstream'};

                    throw Exception::Validator::Fields gettext("Unknown stick_to option \"%s\"", $stick_to)
                      if !in_array($stick_to, $STICK_TO_VALID_VALUES);
                  }
            },
            api => 1,
        },
    );

    delete @model_fields{
        qw(
          is_tutby
          )
      };

    return \%model_fields;
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        (
            $self->check_rights('view_search_filters__login')
            ? ({name => 'login', label => gettext('Login'), login_filter => 'video_an_partner=1'})
            : ()
        ),
        {name => 'page_id',     label => gettext('Page ID')},
        {name => 'category_id', label => gettext('Categories ID')},
        {name => 'id',          label => gettext('Block ID')},
        {name => 'caption',     label => gettext('Block\'s caption')},
        {name => 'page.domain', label => gettext('Resource')},
        {name => 'multistate',  label => gettext('Status')},
    ];
}

sub get_add_fields {
    my ($self) = @_;

    my $result = $self->SUPER::get_add_fields();
    foreach (
        qw (
        auto_repeat
        count_positions
        hide_at_the_end
        light_color_scheme
        stick_outstream
        stick_to
        )
      )
    {
        $result->{$_} = TRUE;
    }

    return $result;
}

sub collect_editable_fields {
    my ($self, $data) = @_;

    my $result = $self->SUPER::collect_editable_fields($data);
    foreach (
        qw (
        auto_repeat
        count_positions
        hide_at_the_end
        light_color_scheme
        stick_to
        stick_outstream
        )
      )
    {
        $result->{$_} = TRUE;
    }

    return $result;
}

sub get_need_update_in_bk_fields {
    my ($self) = @_;

    my $result = $self->SUPER::get_need_update_in_bk_fields();
    foreach (
        qw (
        auto_repeat
        hide_at_the_end
        light_color_scheme
        stick_outstream
        stick_to
        )
      )
    {
        $result->{$_} = TRUE;
    }

    return $result;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $self->SUPER::hook_set_initialize_settings($opts);

    if (defined $opts->{'stick_outstream'} && $opts->{'stick_outstream'}) {
        $opts->{'stick_to'}           //= 'auto';
        $opts->{'light_color_scheme'} //= 0;
    }

}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    $self->SUPER::hook_fields_processing_before_validation($opts);

    if (defined $opts->{'stick_outstream'} && !$opts->{'stick_outstream'}) {
        foreach (qw(stick_to light_color_scheme)) {
            $opts->{$_} = undef unless defined($opts->{$_});
        }
    }

    delete $opts->{count_positions};
}

sub without_yandex_video_search {TRUE}

sub get_incompatible_platforms {[$VIDEO_PLATFORM_MOBILE, $VIDEO_PLATFORM_SMART_TV]}

sub get_types_ids {[$INPAGE]}

TRUE;
