package Application::Model::Product::VideoAN::Site::Video::InternalContent::ContentBrand;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Denied;
use Exception::Validation::BadArguments;

sub accessor      {'content_brand'}
sub db_table_name {'content_brand'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB::VideoAN',);

__PACKAGE__->register_rights(
    [
        {
            name        => 'video_an_site_content_brand',
            description => d_gettext('Rights to use video AN sites content brand'),
            rights      => {
                content_brand_view_all          => d_gettext('Right to view all content brands'),
                content_brand_add_video_an_site => d_gettext('Right to add brand type'),
            }
        }
    ]
);

__PACKAGE__->model_fields(
    id      => {default => TRUE, db => TRUE, pk => TRUE,},
    caption => {default => TRUE, db => TRUE,},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        id      => {type => 'number', label => d_gettext('Brand type ID')},
        caption => {type => 'text',   label => d_gettext('Caption')},
    }
);

sub add {
    my ($self, $caption) = @_;

    throw Exception::Denied unless $self->check_short_rights('add_video_an_site');

    throw Exception::Validation::BadArguments gettext('Expected caption') unless length($caption);

    return $self->partner_db_table()->add({caption => $caption});
}

sub query_filter {
    my ($self, $filter) = @_;

    throw Exception::Denied unless $self->check_short_rights('view_all');

    return $filter;
}

TRUE;
