package Application::Model::Product::VideoAN::Site::Video::InternalContent::ContentType;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Denied;

sub accessor      {'content_type'}
sub db_table_name {'content_type'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB::VideoAN',);

__PACKAGE__->register_rights(
    [
        {
            name        => 'video_an_site_content_type',
            description => d_gettext('Rights to use video AN sites content type'),
            rights      => {content_type_view_all => d_gettext('Right to view all content type')}
        }
    ]
);

__PACKAGE__->model_fields(
    id      => {default => TRUE, db => TRUE, pk   => TRUE,},
    caption => {default => TRUE, db => TRUE, i18n => TRUE},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        id      => {type => 'number', label => d_gettext('Content type ID')},
        caption => {type => 'text',   label => d_gettext('Caption')},
    }
);

sub query_filter {
    my ($self, $filter) = @_;

    throw Exception::Denied unless $self->check_short_rights('view_all');

    return $filter;
}

TRUE;
