package Application::Model::Product::VideoAN::Site::Video::InternalContent::DictionaryWords;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Denied;

sub accessor      {'dictionary_words'}
sub db_table_name {'dictionary_words'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB::VideoAN',);

__PACKAGE__->register_rights(
    [
        {
            name        => 'video_an_site_dictionary_words',
            description => d_gettext('Rights to use video AN sites dictionary words'),
            rights      => {dictionary_words_view_all => d_gettext('Right to view all words')}
        }
    ]
);

__PACKAGE__->model_fields(
    content_id => {default => TRUE, db => TRUE, pk => TRUE,},
    word       => {default => TRUE, db => TRUE, pk => TRUE,},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        content_id => {type => 'number', label => d_gettext('Content ID')},
        word       => {type => 'text',   label => d_gettext('Word')},
    }
);

sub query_filter {
    my ($self, $filter) = @_;

    throw Exception::Denied unless $self->check_short_rights('view_all');

    return $filter;
}

TRUE;
