package Application::Model::Product::VideoAN::Site::Video::InternalContent::InternalContentGenres;

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'internal_content_genres'}
sub db_table_name {'internal_content_genres'}

__PACKAGE__->model_accessors(
    partner_db     => 'Application::Model::PartnerDB::VideoAN',
    internal_genre => 'Application::Model::Product::VideoAN::Site::Video::InternalGenre',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'video_an_site_internal_content_genres',
            description => d_gettext('Rights to use video AN sites internal content genres'),
            rights      => {}
        }
    ]
);

__PACKAGE__->model_fields(
    content_id => {default => TRUE, db => TRUE, pk => TRUE,},
    genre_id   => {default => TRUE, db => TRUE, pk => TRUE,},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        content_id     => {type => 'number', label => d_gettext('Internal content ID')},
        genre_id       => {type => 'number', label => d_gettext('Internal genre ID')},
        internal_genre => {
            type           => 'subfilter',
            model_accessor => 'internal_genre',
            field          => 'genre_id',
            fk_field       => 'id',
            label          => d_gettext('Internal genre'),
        },
    }
);

TRUE;
