package Application::Model::Product::VideoAN::Site::Video::PartnerAndInternalGenre;

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'partner_and_internal_genre'}
sub db_table_name {'partner_and_internal_genre'}

__PACKAGE__->model_accessors(
    partner_db     => 'Application::Model::PartnerDB::VideoAN',
    partner_genre  => 'Application::Model::Product::VideoAN::Site::Video::PartnerGenre',
    internal_genre => 'Application::Model::Product::VideoAN::Site::Video::InternalGenre',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'partner_and_internal_genre',
            description => d_gettext('Rights to use partner and internal genre'),
            rights      => {}
        }
    ]
);

__PACKAGE__->model_fields(
    partner_id  => {default => TRUE, db => TRUE, pk => TRUE,},
    internal_id => {default => TRUE, db => TRUE, pk => TRUE,},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        partner_id    => {type => 'number', label => d_gettext('Partner genre ID')},
        internal_id   => {type => 'number', label => d_gettext('Internal genre ID')},
        partner_genre => {
            type           => 'subfilter',
            model_accessor => 'partner_genre',
            field          => 'partner_id',
            fk_field       => 'id',
            label          => d_gettext('Partner genre'),
        },
        internal_genre => {
            type           => 'subfilter',
            model_accessor => 'internal_genre',
            field          => 'internal_id',
            fk_field       => 'id',
            label          => d_gettext('Internal genre'),
        },
    }
);

TRUE;
