package Application::Model::Queue::Support;
use qbit;

use base qw(QBit::Application::Model);

use Exception::Support;

use Application::Model::Queue::Support::BlockedBrands;
use Application::Model::Queue::Support::UnmoderatedDSP;

sub accessor {'support'}

my %CLASS_BY_NAME = map {$_->method => $_} qw(
  Application::Model::Queue::Support::BlockedBrands
  Application::Model::Queue::Support::UnmoderatedDSP
  );

sub get_object {
    my ($self, $name) = @_;

    my $class = $CLASS_BY_NAME{$name};

    throw Exception::Support "unsupported method '$name'" unless $class;

    return bless {}, $class;
}

sub process_from_json {
    my ($self, $data) = @_;

    my $result;
    try {
        my $ticket = $data->{params} && $data->{params}{ticket};
        if (my $url = delete $data->{url}) {
            my $opts = $self->app->startrek->get_attachment($url);
            throw Exception::Support "no attachment on '$url" unless $opts;
            $data = $opts;
        }

        my $params = delete $data->{params};
        my $method = delete $data->{method};
        throw Exception::Support 'no method' unless $method;
        throw Exception::Support 'no params' unless $params;

        $params->{ticket} = $ticket;

        my $object = $self->get_object($method);
        $object->check_input_params($self->app, $params);

        $params->{nomail}      = TRUE;
        $params->{noresend}    = TRUE;
        $params->{return_list} = TRUE;

        $result = $object->apply($self->app, $params);
    }
    catch Exception::Support with {
        my ($e) = @_;
        throw $e;
    }
    catch {
        my ($e) = @_;
        throw Exception::Support $e;
    };
    return $result;
}

sub fill_tables {
    my ($self, $result) = @_;
    $self->apply_by_parts(
        list => $result->{changed_pages} // [],
        max  => 100,
        main => sub {
            $self->app->partner_db->_do(
                sprintf("insert ignore into `oneshot_pages` (page_id) values %s", join(',', map {"($_)"} @{$_[0]})));
        }
    );
    $self->apply_by_parts(
        list => $result->{changed_block} // [],
        max  => 100,
        main => sub {
            $self->app->partner_db->_do(
                sprintf(
                    "insert ignore into `oneshot_blocks` (prefix,page_id,block_id) values %s",
                    join(
                        ',',
                        map {
                            '('
                              . join(',', map {"'$_'"} split_block_public_id($_)) . ')'
                          } @{$_[0]}
                        )
                       )
            );
        }
    );
}

sub apply_by_parts {
    my ($self, %params) = @_;
    my ($list, $max, $main, $skip, $error) = delete @params{qw(list max main skip error)};

    my $start = 0;
    while ($start < @$list) {
        my $end = $start + $max;
        if ($end > $#$list) {
            $end = $#$list;
        }
        my @part = @{$list}[$start .. $end];
        try {
            $main->(\@part, %params);
        }
        catch {
            my ($e) = @_;
            $skip->(\@part) if $skip;
            $error->($e) if $error;
        };
        $start = $end + 1;
    }
}

1;
