package Application::Model::Queue::Support::Apply::Method;

use qbit;

sub form_name {'apply_method'}
sub data_name {form_name()}

my $valid = [qw(add update replace)];

sub field {
    my ($self) = @_;

    return +{
        name     => $self->form_name,
        label    => gettext('Apply method'),
        type     => 'select',
        required => TRUE,
        items    => [
            {
                label => gettext('Add only new'),
                value => 'add'
            },
            {
                label => gettext('Add new and change exists'),
                value => 'update'
            },
            {
                label => gettext('Delete all and add new'),
                value => 'replace'
            }
        ]
    };
}

sub check {
    my ($self, $app, $data) = @_;
    return (
        in_array($data->{$self->form_name} // '', $valid)
        ? ''
        : gettext('Value must be in: [%s]', join(', ', @$valid))
    );
}

sub get_method {
    my ($self, $data) = @_;

    return +{map {$_ => $data->{$self->data_name} eq $_} @$valid};
}

1;
