package Application::Model::Queue::Support::Author::Ticket;

use qbit;

sub form_name {'ticket'}
sub data_name {'owner_data'}

sub field {
    my ($self) = @_;
    return +{
        name     => $self->form_name,
        label    => gettext('Origin ticket'),
        type     => 'input',
        trim     => TRUE,
        required => TRUE,
    };
}

sub check {
    my ($self, $app, $data) = @_;

    my $ticket = $data->{$self->form_name} // '';
    unless ($ticket =~ /^[A-Z]+-\d+/) {
        return (gettext('No valid ticket'), 1);
    }
    my $current_user = $self->get_current_user_data($app);
    my $ticket_user = $self->get_ticket_user_data($app, $ticket);
    unless ($ticket_user) {
        return (gettext('No valid user in ticket %s', $ticket), 1);
    }
    $current_user //= $ticket_user;

    $data->{$self->data_name} = {
        ticket       => $ticket,
        current_user => $current_user->{id},
        ticket_user  => $ticket_user->{domain_login},
    };

    return ('', 1);
}

sub get_ticket_user_data {
    my ($self, $app, $ticket) = @_;

    my $user;
    if (my $issue = eval {$app->startrek->get_issue($ticket)}) {
        if (my $login = $issue->{assignee}{id} // $issue->{createdBy}{id}) {
            $user = $app->partner_db->users->get_all(
                fields => [qw(id login domain_login email)],
                filter => [domain_login => '=' => \$login],
            )->[0];
        }
    }

    return $user;
}

sub get_current_user_data {
    my ($self, $app) = @_;

    my $user;
    if (my $user_id = $app->get_option('cur_user', {})->{'id'}) {
        $user = $app->partner_db->users->get_all(
            fields => [qw(id login domain_login email)],
            filter => [id => '=' => \$user_id],
        )->[0];
    }

    return $user;
}

sub get_action_log_comment {
    my ($self, $data, $title) = @_;

    my $d = $data->{$self->data_name};
    return {
        comment => sprintf("%s: %s", $title, $d->{ticket} // 'no_ticket'),
        user_id => $d->{current_user},
    };
}

1;
