package Application::Model::Queue::Support::BlockedBrands;

use qbit;
use base qw(Application::Model::Queue::Support::Base);

my $structure = {
    target => [
        qw(
          Application::Model::Queue::Support::Target::Logins
          Application::Model::Queue::Support::Target::Pages
          Application::Model::Queue::Support::Target::Blocks
          )
    ],
    source => [
        qw(
          Application::Model::Queue::Support::Source::SampleBrands
          Application::Model::Queue::Support::Source::Brands
          )
    ],
    apply => [
        qw(
          Application::Model::Queue::Support::Apply::Method
          )
    ],
    filter => [
        qw(
          Application::Model::Queue::Support::Filter::SpecialBlock
          )
    ],
};

sub get_structure_data {$structure}

sub method     {'change_blocked_brands'}
sub right_add  {'queue_add_change_blocked_brands'}
sub right_view {'queue_change_blocked_brands'}
sub title      {gettext('Change list blocked brands')}

sub apply_real_process {
    my ($self, $app, $data) = @_;

    my $list = $self->get_blocks($app, $data);
    return $self->apply_to_list($app, $data, $list);
}

sub get_start_message {gettext("Add task for update blocked brands")}
sub get_done_message  {gettext("Finish task for update blocked brands")}

1;
