package Application::Model::Queue::Support::Filter::UnmoderatedRtbAuction;

use qbit;

sub get_filter {
    my ($self, $app, $data, $filters) = @_;

    my @skip_block;
    for my $accessor (@{$app->product_manager->get_block_model_names}) {
        push @skip_block, $accessor
          unless $app->$accessor->DOES('Application::Model::Role::Block::Has::UnmoderatedDSPs');
    }
    $filters->{skip_block_model} = \@skip_block if @skip_block;

    my @skip_page;
    for my $accessor (@{$app->product_manager->get_page_model_accessors}) {
        push @skip_page, $accessor unless $app->$accessor->DOES('Application::Model::Role::Has::UnmoderatedRtbAuction');
    }
    $filters->{skip_page_model} = \@skip_page if @skip_page;
}

1;
