package Application::Model::Queue::Support::Source::Brands;

use qbit;
use Utils::PublicID;
use Utils::DB qw(fields_to_filter model_to_prefix);
use PiConstants qw($BLOCKED_CPM_VALUE);
use Utils::Logger qw(INFOF);

use Application::Model::Queue::Support::Apply::ApplyGM;
use Application::Model::Queue::Support::Apply::Method;

sub form_name {'brands'}
sub data_name {'brand_list'}
sub title     {'change blocked brands'}

sub field {
    my ($self) = @_;

    return +{
        name  => $self->form_name,
        label => gettext('Brand IDs'),
        type  => 'textarea',
        trim  => TRUE,
    };
}

sub check {
    my ($self, $app, $data) = @_;

    my @brands = sort {$a <=> $b} split /\s*[,\n]\s*/, $data->{$self->form_name};

    my $list = $app->partner_db->tns_dict_brand->get_all(
        fields => ["bid"],
        filter => [bid => 'IN' => \\@brands],
    );

    my %has = map {$_->{bid} => TRUE} @$list;
    my @fail = grep {!$has{$_}} @brands;
    if (@fail) {
        return join(', ', @fail);
    }

    my @result = sort {$a <=> $b} keys %has;
    $data->{$self->data_name} = \@result;

    return ('', scalar @result);
}

sub can_apply {
    my ($self, $data) = @_;
    return exists $data->{$self->data_name};
}

my @fields = qw(page_id block_id bid cpm blocked);

sub apply_to_list {
    my ($self, $app, $data, $list) = @_;

    my $method = Application::Model::Queue::Support::Apply::Method->get_method($data);
    my $bids   = $data->{$self->data_name};
    my $md_data;
    my @deleted_brands;
    my @add_brands;
    my @blocks_maked;

    my $comment = Application::Model::Queue::Support::Author::Ticket->get_action_log_comment($data, $self->title);

    my $result = Application::Model::Queue::Support::Base->apply_block_list_by_state(
        app         => $app,
        data        => $data,
        list        => $list,
        fields      => [],
        comment     => $comment,
        sub_godmode => sub {
            my (%params) = @_;
            my ($row, $bk_data) = @params{qw(row bk_data)};
            my $brands = $bk_data->{Brand} // {};

            if ($method->{replace}) {
                $brands = {};
            }

            for my $bid (@$bids) {
                if (!exists $brands->{$bid} || $method->{update}) {
                    $brands->{$bid} = {
                        currency => 'RUB',
                        value    => $BLOCKED_CPM_VALUE,
                    };
                }
            }

            $bk_data->{Brand} = $brands;
            return $bk_data;
        },
        sub_model => sub {
            my (%p) = @_;
            my ($app, $block, $data) = @p{qw(app block data)};
            my $accessor = $block->{block_model};
            my $model    = $app->$accessor;
            my $row      = $model->get($block->{public_id}, fields => ['brands']);

            my @brands;
            if ($method->{replace}) {
                @brands = map +{bid => $_, blocked => 1}, @$bids;
            } else {
                my %has = map {$_->{bid} => $_} @{$row->{brands}};
                if ($method->{add}) {
                    @brands = map +{bid => $_, blocked => 1}, grep {!$has{$_}} @$bids;
                    push @brands, @{$row->{brands}};
                } else {
                    @brands = map +{bid => $_, blocked => 1}, grep {delete $has{$_} || 1} @$bids;
                    push @brands, values %has;
                }
            }

            $model->do_action($block->{public_id}, 'edit', brands => [sort {$a->{bid} <=> $b->{bid}} @brands]);
            $md_data->{$accessor}{$block->{public_id}} = $row;
        },
        sub_database => sub {
            my ($blocks, %params) = @_;

            my $filter = fields_to_filter(['page_id', 'block_id'], $blocks, for_db => TRUE);

            if ($method->{replace}) {
                my $list = $app->partner_db->brands->get_all(fields => \@fields, filter => $filter);
                push @deleted_brands, @$list;
                $app->partner_db->brands->delete($app->partner_db->filter($filter));
            }
            my %ignored;
            if ($method->{update} || $method->{add}) {
                my $ufilter = [AND => [$filter, [bid => 'IN' => \$bids], [blocked => '=' => \0]]];
                my $list = $app->partner_db->brands->get_all(fields => \@fields, filter => $ufilter);
                if ($method->{add}) {
                    for my $row (@$list) {
                        $ignored{$row->{page_id}}{$row->{block_id}}{$row->{bid}} = TRUE;
                    }
                } else {
                    push @deleted_brands, @$list;
                    $app->partner_db->brands->delete($app->partner_db->filter($ufilter));
                }
            }
            my %need_action_log;
            my @ary;
            for my $block (@$blocks) {
                my $has = $ignored{$block->{page_id}}{$block->{block_id}} // {};
                push @ary, map +{
                    page_id  => $block->{page_id},
                    block_id => $block->{block_id},
                    bid      => $_,
                    blocked  => 1,
                    cpm      => undef,
                  },
                  grep {!$has->{$_}} @$bids;

                push @{$need_action_log{$block->{block_model}}}, $block;
            }

            my $sql_modif = $method->{add} ? 'ignore' : 'replace';
            $app->partner_db->transaction(
                sub {
                    $app->partner_db->brands->add_multi(\@ary, $sql_modif => TRUE);
                    Application::Model::Queue::Support::Base->store_action_log(
                        app     => $app,
                        comment => $params{comment},
                        list    => \%need_action_log,
                    );
                }
            );

            push @add_brands, @ary;
            push @blocks_maked, map {$_->{public_id}} @$blocks;

        },
    );

    my %resend = map {$_->{page_id} => undef} @deleted_brands, @add_brands;
    @resend{@{delete $result->{resend} // []}} = ();
    push @blocks_maked, @{delete $result->{blocks} // []};

    return {
        delete_by_model => {
            brands => {
                pk   => ['page_id', 'block_id', 'bid'],
                list => \@deleted_brands,
            }
        },
        add_by_model    => {brands => {list => \@add_brands,}},
        change_by_model => $md_data,
        resend          => [sort keys %resend],
        blocks          => \@blocks_maked,
        %$result,
    };
}

1;
