package Application::Model::Queue::Support::Source::Sample;

use qbit;
use Utils::PublicID;

sub form_name {'sample'}
sub data_name {'sample_block'}

sub field {
    my ($self) = @_;

    return +{
        name  => $self->form_name,
        label => gettext('Sample block'),
        type  => 'input',
        trim  => TRUE,
    };
}

sub check {
    my ($self, $app, $data) = @_;

    my $parts = split_block_public_id($data->{$self->form_name});

    # здесь явный вызов своего метода, иначе при вызове от потомка не получаются правильный данне
    $data->{data_name()} = $parts;
    my $cnt = @{
        $app->partner_db->all_blocks->get_all(
            filter => {
                page_id => $parts->{page_id},
                id      => $parts->{block_id}
            }
        )
      };

    return ('', $cnt);
}

sub can_apply {0}

1;
