package Application::Model::Queue::Support::Source::SampleBrands;

use qbit;
use base qw(Application::Model::Queue::Support::Source::Sample);

sub data_name {'brand_list'}

sub check {
    my ($self, $app, $data) = @_;

    my ($error, $cnt) = $self->SUPER::check($app, $data);
    if ($error || !$cnt) {
        return ($error, $cnt);
    }

    my $value = $data->{$self->SUPER::data_name()};
    my $list  = $app->partner_db->brands->get_all(
        fields => ["bid"],
        filter => [
            AND => [
                [page_id => '=' => \$value->{page_id}], [block_id => '=' => \$value->{block_id}], [blocked => '=' => \1]
            ]
        ],
    );
    my $brands = [sort {$a <=> $b} map {$_->{bid}} @$list];
    $data->{$self->data_name} = $brands;

    return ('', 1);
}

sub can_apply {0}

1;
