package Application::Model::Queue::Support::Source::UnmoderatedDSP;

use qbit;
use Utils::PublicID;
use Utils::DB qw(fields_to_filter model_to_prefix);
use PiConstants qw($BLOCKED_CPM_VALUE);
use Utils::Logger qw(INFOF);

use Application::Model::Queue::Support::Apply::ApplyGM;
use Application::Model::Queue::Support::Apply::Method;

sub form_name {'unmoderated_dsp'}
sub data_name {'unmoderated_dsp_list'}
sub title     {'add unmoderated_dsp'}

sub field {
    my ($self) = @_;

    return +{
        name  => $self->form_name,
        label => gettext('Unmoderated DSP IDs'),
        type  => 'textarea',
        trim  => TRUE,
    };
}

sub check {
    my ($self, $app, $data) = @_;

    my @dsp = split /\s*[,\n]\s*/, $data->{$self->form_name};

    my $list = $app->partner_db->dsp->get_all(
        fields => ["id"],
        filter => [AND => [[id => 'IN' => \\@dsp], [unmoderated_rtb_auction => '=' => \1],]],
    );

    my %has = map {$_->{id} => TRUE} @$list;
    my @fail = grep {!$has{$_}} @dsp;
    if (@fail) {
        return join(', ', @fail);
    }

    my @result = keys %has;
    $data->{$self->data_name} = \@result;

    return ('', scalar @result);
}

sub can_apply {
    my ($self, $data) = @_;
    return exists $data->{$self->data_name};
}

my $fields   = [qw(page_id block_id dsp_id)];
my $opt_name = 'unmoderated-rtb-auction';

sub apply_to_list {
    my ($self, $app, $data, $list) = @_;

    my $dsps = $data->{$self->data_name};

    my $md_data;
    my @blocks_maked;
    my @all_add_dsp;
    my @all_add_dsp_un;

    my $comment = Application::Model::Queue::Support::Author::Ticket->get_action_log_comment($data, $self->title);

    my $result = Application::Model::Queue::Support::Base->apply_block_list_by_state(
        app         => $app,
        data        => $data,
        list        => $list,
        fields      => ['mincpm'],
        comment     => $comment,
        sub_godmode => sub {
            my (%params) = @_;
            my ($row, $bk_data) = @params{qw(row bk_data)};

            my %dsp = map {$_ => TRUE} @$dsps;
            my $dsp_info = $bk_data->{DSPInfo} // [];
            for my $info (@$dsp_info) {
                if (delete $dsp{$info->{DSPID}}) {
                    my @e = grep {$_ ne $opt_name} @{$info->{PageDspOptions}{Enable}  // []};
                    my @d = grep {$_ ne $opt_name} @{$info->{PageDspOptions}{Disable} // []};
                    push @e, $opt_name;
                    $info->{PageDspOptions}{Enable}  = \@e;
                    $info->{PageDspOptions}{Disable} = \@d;
                }
            }
            for my $dsp_id (keys %dsp) {
                push @$dsp_info,
                  {
                    DSPID          => $dsp_id,
                    CPM            => $row->{mincpm} // 0,
                    PageDspOptions => {
                        Enable  => [$opt_name],
                        Disable => [],
                    }
                  };
            }
            $bk_data->{DSPInfo} = $dsp_info;

            return $bk_data;
        },
        sub_model => sub {
            my (%p) = @_;
            my ($app, $block, $data) = @p{qw(app block data)};
            my $accessor = $block->{block_model};
            my $model    = $app->$accessor;

            my $row = $model->get($block->{public_id}, fields => ['dsps', 'unmoderated_dsps']);

            my $dsps_un = array_uniq($dsps, $row->{unmoderated_dsps});
            my $dsps    = array_uniq($dsps, $row->{dsps});

            $model->do_action($block->{public_id}, 'edit', unmoderated_dsps => $dsps_un, dsps => $dsps);
            $md_data->{$accessor}{$block->{public_id}} = $row;
        },
        sub_database => sub {
            my ($blocks, %params) = @_;

            my $filter =
              [AND => [[dsp_id => 'IN' => \$dsps], fields_to_filter(['page_id', 'block_id'], $blocks, for_db => TRUE)]];

            my %has_dsp;
            for my $row (@{$app->partner_db->block_dsps->get_all(filter => $filter, fields => $fields)}) {
                $has_dsp{$row->{page_id}}{$row->{block_id}}{$row->{dsp_id}} = TRUE;
            }
            my %has_dsp_un;
            for my $row (@{$app->partner_db->block_dsps_unmoderated->get_all(filter => $filter, fields => $fields)}) {
                $has_dsp_un{$row->{page_id}}{$row->{block_id}}{$row->{dsp_id}} = TRUE;
            }

            my %need_action_log;
            my @add_dsp;
            my @add_dsp_un;
            for my $row (@$blocks) {
                my $has = $has_dsp{$row->{page_id}}{$row->{block_id}} // {};
                push @add_dsp, map +{
                    page_id  => $row->{page_id},
                    block_id => $row->{block_id},
                    dsp_id   => $_,
                  },
                  grep {!$has->{$_}} @$dsps;

                $has = $has_dsp_un{$row->{page_id}}{$row->{block_id}} // {};
                push @add_dsp_un, map +{
                    page_id  => $row->{page_id},
                    block_id => $row->{block_id},
                    dsp_id   => $_,
                  },
                  grep {!$has->{$_}} @$dsps;

                push @{$need_action_log{$row->{block_model}}}, $row;
            }

            $app->partner_db->transaction(
                sub {
                    $app->partner_db->block_dsps->add_multi(\@add_dsp);
                    $app->partner_db->block_dsps_unmoderated->add_multi(\@add_dsp_un);
                    Application::Model::Queue::Support::Base->store_action_log(
                        app     => $app,
                        comment => $params{comment},
                        list    => \%need_action_log,
                    );
                }
            );
            push @all_add_dsp,    @add_dsp;
            push @all_add_dsp_un, @add_dsp_un;
            push @blocks_maked,   map {$_->{public_id}} @$blocks;
        },
    );

    my %resend = map {$_->{page_id} => undef} @all_add_dsp, @all_add_dsp_un;
    @resend{@{delete $result->{resend} // []}} = ();
    push @blocks_maked, @{delete $result->{blocks} // []};

    return {
        add_by_model => {
            block_dsps             => {list => \@all_add_dsp,},
            block_dsps_unmoderated => {list => \@all_add_dsp_un,}
        },
        change_by_model => $md_data,
        resend          => [sort keys %resend],
        blocks          => \@blocks_maked,
        %$result,
    };
}

1;
