package Application::Model::Queue::Support::Source::UnmoderatedRtbAuction;

use qbit;
use Utils::PublicID;
use Utils::Logger qw(INFOF);

sub form_name {''}
sub data_name {''}
sub title     {'set unmoderated_rtb_auction'}

sub field {
    return ();
}

sub check {
    my ($self, $app, $data) = @_;

    return ('', 1);
}

my $field = 'unmoderated_rtb_auction';

sub apply_to_list {
    my ($self, $app, $data, $list) = @_;

    INFOF("APPLY_TO_LIST '%s' size=%d", $self->title, scalar(@$list));

    my $comment = Application::Model::Queue::Support::Author::Ticket->get_action_log_comment($data, $self->title);

    my %by_model;
    for my $row (@$list) {
        push @{$by_model{$row->{page_model}}}, $row;
    }

    my %current;
    my @skip;
    my @pages;
    my @errors;
    for my $accessor (keys %by_model) {
        my $pn = $app->$accessor->get_page_id_field_name;
        $current{$accessor}{pk} = [$pn];
        $app->support->apply_by_parts(
            list => $by_model{$accessor},
            max  => 100,
            main => sub {
                my @p = map {$_->{page_id}} @{$_[0]};
                my $filter = [$pn => IN => \\@p];

                my $table = $app->$accessor->partner_db_table();

                if ($table->have_fields('model')) {
                    $filter = ['AND', [['model', '=', \$accessor], $filter]];
                }

                my $list = $table->get_all(
                    fields => [$pn, $field],
                    filter => $filter
                );
                $app->partner_db->transaction(
                    sub {
                        $table->edit($app->partner_db->filter($filter), {$field => 1});
                        Application::Model::Queue::Support::Base->store_action_log(
                            app     => $app,
                            comment => $comment,
                            list    => {$accessor => $_[0]},
                        );
                    }
                );
                push @{$current{$accessor}{list}}, @$list;
                push @pages, @p;
            },
            # skip => sub {
            #     push @skip, @{$_[0]};
            # },
            error => sub {
                push @errors, $_[0];
            }
        );
    }

    return {
        modify_by_model => \%current,
        skip            => \@skip,
        resend          => \@pages,
        errors          => \@errors,
    };
}

1;
